/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model.textproperties;

import org.apache.poi.hslf.model.textproperties.TextProp;

public class BitMaskTextProp
extends TextProp
implements Cloneable {
    private String[] subPropNames;
    private int[] subPropMasks;
    private boolean[] subPropMatches;

    public String[] getSubPropNames() {
        return this.subPropNames;
    }

    public boolean[] getSubPropMatches() {
        return this.subPropMatches;
    }

    public BitMaskTextProp(int sizeOfDataBlock, int maskInHeader, String overallName, String[] subPropNames) {
        super(sizeOfDataBlock, maskInHeader, "bitmask");
        this.subPropNames = subPropNames;
        this.propName = overallName;
        this.subPropMasks = new int[subPropNames.length];
        this.subPropMatches = new boolean[subPropNames.length];
        for (int i = 0; i < this.subPropMasks.length; ++i) {
            this.subPropMasks[i] = 1 << i;
        }
    }

    public int getWriteMask() {
        return this.dataValue;
    }

    public void setValue(int val) {
        this.dataValue = val;
        for (int i = 0; i < this.subPropMatches.length; ++i) {
            this.subPropMatches[i] = false;
            if ((this.dataValue & this.subPropMasks[i]) == 0) continue;
            this.subPropMatches[i] = true;
        }
    }

    public boolean getSubValue(int idx) {
        return this.subPropMatches[idx];
    }

    public void setSubValue(boolean value, int idx) {
        if (this.subPropMatches[idx] == value) {
            return;
        }
        this.dataValue = value ? (this.dataValue += this.subPropMasks[idx]) : (this.dataValue -= this.subPropMasks[idx]);
        this.subPropMatches[idx] = value;
    }

    public Object clone() {
        BitMaskTextProp newObj = (BitMaskTextProp)super.clone();
        newObj.subPropMatches = new boolean[this.subPropMatches.length];
        return newObj;
    }
}

