/*
 * Decompiled with CFR 0.152.
 */
package CM.core;

import CM.Configuration.Configuration;
import CM.GUI.MyTableModel;
import CM.core.ExtraColumnElement;
import CM.core.SearchObject;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class PdfTools {
    private Logger log = Logger.getLogger(PdfTools.class);
    String headline1 = "Scientific search results and data analisys\nat " + new Date();
    String headline1CV = "Scientific Data Analisys\nGenerated at" + new Date();

    public boolean exporPDF(String file, SearchObject so, int[] sortIndexes) throws FileNotFoundException, DocumentException {
        int z;
        float[] widths;
        Chunk chunk;
        MyTableModel model = new MyTableModel("whatever");
        model.setSo(so);
        NumberFormat nf = Configuration.getInstance().getNumberFormat();
        Font headFont = FontFactory.getFont((String)"Helvetica", (float)16.0f, (int)1, (Color)Color.DARK_GRAY);
        Font mainParagraphFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1, (Color)Color.DARK_GRAY);
        Font tableHeaderFont = FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)1, (Color)Color.DARK_GRAY);
        Font linkFont = FontFactory.getFont((String)"Helvetica-Bold", (float)8.0f, (int)4, (Color)Color.BLUE);
        Font tableFont = FontFactory.getFont((String)"Helvetica", (float)6.0f, (Color)Color.BLACK);
        Font tableLinkFont = FontFactory.getFont((String)"Helvetica", (float)6.0f, (Color)Color.BLUE);
        Font normalFont = FontFactory.getFont((String)"Helvetica", (float)10.0f, (Color)Color.BLACK);
        Document d = new Document(PageSize.A4);
        PdfWriter.getInstance((Document)d, (OutputStream)new FileOutputStream(file));
        d.open();
        Paragraph headlineParag = null;
        Paragraph headlineParag2 = null;
        if (!so.isCV) {
            headlineParag = new Paragraph(this.headline1, headFont);
            chunk = new Chunk("Snapshot Powered by Citation Machine beta 2.18", linkFont);
            try {
                chunk.setAnchor(new URL("http://eia.udg.edu/scholar-agent/"));
            }
            catch (MalformedURLException ex) {
                this.log.error((Object)ex);
                return false;
            }
            headlineParag2 = new Paragraph(chunk);
        } else {
            headlineParag = new Paragraph(this.headline1CV, headFont);
            chunk = new Chunk("CV Powered by Citation Machine beta 2.18", linkFont);
            try {
                chunk.setAnchor(new URL("http://eia.udg.edu/scholar-agent/"));
            }
            catch (MalformedURLException ex) {
                this.log.error((Object)ex);
                return false;
            }
            headlineParag2 = new Paragraph(chunk);
        }
        headlineParag.setAlignment("center");
        headlineParag2.setAlignment("center");
        d.add((Element)headlineParag);
        d.add((Element)headlineParag2);
        Paragraph generalSummary = new Paragraph("\nSummary\n", headFont);
        Paragraph noPapers = new Paragraph("Papers: ", mainParagraphFont);
        noPapers.add((Object)new Chunk("" + model.getRowCount(), normalFont));
        Paragraph cites = new Paragraph("Citations: ", mainParagraphFont);
        cites.add((Object)new Chunk("" + model.getSo().getCitnum(), normalFont));
        Paragraph selfCites = new Paragraph("Self-citations: ", mainParagraphFont);
        selfCites.add((Object)new Chunk("" + model.getSo().getSelfCitnum(), normalFont));
        Paragraph avg = new Paragraph("Cites/paper: ", mainParagraphFont);
        avg.add((Object)new Chunk("" + nf.format(model.getAVGall()), normalFont));
        Paragraph avgs = new Paragraph("Cites/paper excluding self-citations: ", mainParagraphFont);
        avgs.add((Object)new Chunk("" + nf.format(model.getAVGallNoSelf()), normalFont));
        Paragraph h = new Paragraph("H index: ", mainParagraphFont);
        h.add((Object)new Chunk("" + nf.format(model.getHindex()), normalFont));
        Paragraph hs = new Paragraph("H index excluding self-citations: ", mainParagraphFont);
        hs.add((Object)new Chunk("" + nf.format(model.getHSindex()), normalFont));
        Paragraph m = new Paragraph("Median: ", mainParagraphFont);
        m.add((Object)new Chunk("" + nf.format(model.getMedian()), normalFont));
        Paragraph ms = new Paragraph("Median excluding self-citations: ", mainParagraphFont);
        ms.add((Object)new Chunk("" + nf.format(model.getMedianS()), normalFont));
        Paragraph a = new Paragraph("A index: ", mainParagraphFont);
        a.add((Object)new Chunk("" + nf.format(model.getAindex()), normalFont));
        Paragraph g = new Paragraph("G index: ", mainParagraphFont);
        g.add((Object)new Chunk("" + nf.format(model.getGindex()), normalFont));
        d.add((Element)generalSummary);
        if (so.isCV) {
            Paragraph CVNamePara = new Paragraph("CV name: ", mainParagraphFont);
            CVNamePara.add((Object)new Chunk("" + so.getCVName(), normalFont));
            d.add((Element)CVNamePara);
        }
        d.add((Element)noPapers);
        d.add((Element)cites);
        d.add((Element)selfCites);
        d.add((Element)avg);
        if (so.isCV || !so.isCV && so.isSelfcitationFiltered) {
            d.add((Element)avgs);
        }
        d.add((Element)h);
        if (so.isCV || !so.isCV && so.isSelfcitationFiltered) {
            d.add((Element)hs);
        }
        d.add((Element)m);
        if (so.isCV || !so.isCV && so.isSelfcitationFiltered) {
            d.add((Element)ms);
        }
        d.add((Element)a);
        d.add((Element)g);
        if (!so.isCV) {
            Paragraph snapshotSummary = new Paragraph("\nSnapshot settings\n", headFont);
            d.add((Element)snapshotSummary);
            Paragraph incNamesParag = new Paragraph("Names included", mainParagraphFont);
            List inclNameList = new List();
            for (int i = 0; i < so.getInclNames().length; ++i) {
                inclNameList.add((Object)new ListItem(so.getInclNames()[i]));
            }
            Paragraph exclNamesParag = new Paragraph("Names excluded", mainParagraphFont);
            List exclNameList = new List();
            for (int j = 0; j < so.getExclNames().length; ++j) {
                exclNameList.add((Object)new ListItem(so.getExclNames()[j]));
            }
            Paragraph searchAreasParag = new Paragraph("Search areas", mainParagraphFont);
            List searchArList = new List();
            for (int k = 0; k < so.getAreas().length; ++k) {
                searchArList.add((Object)new ListItem(so.getAreas()[k]));
            }
            String from_to = "";
            if (so.getYearFrom() > 0) {
                from_to = from_to + so.getYearFrom();
            }
            if (so.getYearTo() > 0) {
                from_to = from_to + " - " + so.getYearTo();
            }
            Paragraph searhFROMTO = new Paragraph(from_to);
            Paragraph searchBetween = new Paragraph("Search between", mainParagraphFont);
            Paragraph searhDatePara = new Paragraph("Search was performed at ", mainParagraphFont);
            Paragraph searchDate = new Paragraph(so.getSearchDate().toString());
            d.add((Element)incNamesParag);
            d.add((Element)inclNameList);
            if (so.getExclNames() != null && so.getExclNames().length > 0 && !so.getExclNames()[0].equals("")) {
                d.add((Element)exclNamesParag);
                d.add((Element)exclNameList);
            }
            if (so.getAreas() != null && so.getAreas().length > 0 && !so.getAreas()[0].equals("")) {
                d.add((Element)searchAreasParag);
                d.add((Element)searchArList);
            }
            try {
                if (searhFROMTO.getChunks().get(0) != "") {
                    d.add((Element)searchBetween);
                    d.add((Element)searhFROMTO);
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            d.add((Element)searhDatePara);
            d.add((Element)searchDate);
        }
        Paragraph details = new Paragraph("\nDetails\n", headFont);
        d.add((Element)details);
        int extraColumnNum = so.getSearchResults().get(0).getExtraColumnElementArray().size();
        Paragraph spaceHolder = new Paragraph(" ");
        PdfPTable table = null;
        if (so.isCV) {
            widths = new float[]{1.0f, 4.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            table = new PdfPTable(widths);
        } else {
            widths = new float[9 + extraColumnNum];
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = i == 1 ? 4.0f : 1.0f;
            }
            table = new PdfPTable(widths);
        }
        table.setWidthPercentage(100.0f);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph("Papers"));
        if (!so.isCV) {
            cell.setColspan(9 + extraColumnNum);
        } else {
            cell.setColspan(8);
        }
        table.addCell(cell);
        table.addCell((Phrase)new Paragraph("rank", tableHeaderFont));
        table.addCell((Phrase)new Paragraph("title", tableHeaderFont));
        table.addCell((Phrase)new Paragraph("authors", tableHeaderFont));
        table.addCell((Phrase)new Paragraph("cites", tableHeaderFont));
        table.addCell((Phrase)new Paragraph("self-citations", tableHeaderFont));
        table.addCell((Phrase)new Paragraph("publisher", tableHeaderFont));
        table.addCell((Phrase)new Paragraph("media", tableHeaderFont));
        table.addCell((Phrase)new Paragraph("year", tableHeaderFont));
        if (!so.isCV) {
            table.addCell((Phrase)new Paragraph("It's mine", tableHeaderFont));
            for (int k = 0; k < extraColumnNum; ++k) {
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(0).getExtraColumnElementArray().get(k).getName(), tableHeaderFont));
            }
        }
        if (sortIndexes != null) {
            for (z = 0; z < sortIndexes.length; ++z) {
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(sortIndexes[z]).getRank() + "", tableFont));
                Chunk titleChunk = new Chunk(so.getSearchResults().get(sortIndexes[z]).getTitle(), tableLinkFont);
                titleChunk.setAnchor(so.getSearchResults().get(sortIndexes[z]).getLink());
                PdfPCell titleCell = new PdfPCell((Phrase)new Paragraph(titleChunk));
                table.addCell(titleCell);
                ArrayList<String> authors = so.getSearchResults().get(sortIndexes[z]).getAuthors();
                String authorString = "";
                for (int i = 0; i < authors.size(); ++i) {
                    authorString = i < authors.size() - 1 ? authorString + authors.get(i) + ";" : authorString + authors.get(i);
                }
                table.addCell((Phrase)new Paragraph(authorString, tableFont));
                Chunk CitLinkChunk = new Chunk(so.getSearchResults().get(sortIndexes[z]).getCitNum() + "", tableLinkFont);
                CitLinkChunk.setAnchor("http://scholar.google.com/scholar?start=0&hl=en&num=100&as_sdt=2000&cites=" + so.getSearchResults().get(sortIndexes[z]).getCitLink());
                table.addCell((Phrase)new Paragraph(CitLinkChunk));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(sortIndexes[z]).getSelfCitNum() + "", tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(sortIndexes[z]).getPublisher(), tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(sortIndexes[z]).getMedia(), tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(sortIndexes[z]).getYear() + "", tableFont));
                if (so.isCV) continue;
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(sortIndexes[z]).isMine() + "", tableFont));
                for (int b = 0; b < extraColumnNum; ++b) {
                    if (so.getSearchResults().get(sortIndexes[z]).getExtraColumnElementArray().get(b).getType() == ExtraColumnElement.Type.TEXT) {
                        table.addCell((Phrase)new Paragraph(so.getSearchResults().get(sortIndexes[z]).getExtraColumnElementArray().get(b).getContent(), tableFont));
                        continue;
                    }
                    table.addCell((Phrase)new Paragraph(so.getSearchResults().get(sortIndexes[z]).getExtraColumnElementArray().get(b).isIsTrue() + "", tableFont));
                }
            }
        } else {
            for (z = 0; z < so.getSearchResults().size(); ++z) {
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).getRank() + "", tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).getTitle(), tableFont));
                ArrayList<String> authors = so.getSearchResults().get(z).getAuthors();
                String authorString = "";
                for (int i = 0; i < authors.size(); ++i) {
                    authorString = i < authors.size() - 1 ? authorString + authors.get(i) + ";" : authorString + authors.get(i);
                }
                table.addCell((Phrase)new Paragraph(authorString, tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).getCitNum() + "", tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).getSelfCitNum() + "", tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).getPublisher(), tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).getMedia(), tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).getYear() + "", tableFont));
                table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).isMine() + "", tableFont));
                for (int b = 0; b < extraColumnNum; ++b) {
                    if (so.getSearchResults().get(z).getExtraColumnElementArray().get(b).getType() == ExtraColumnElement.Type.TEXT) {
                        table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).getExtraColumnElementArray().get(b).getContent(), tableFont));
                        continue;
                    }
                    table.addCell((Phrase)new Paragraph(so.getSearchResults().get(z).getExtraColumnElementArray().get(b).isIsTrue() + "", tableFont));
                }
            }
        }
        try {
            d.add((Element)spaceHolder);
            d.add((Element)table);
            PdfPTable footer = new PdfPTable(1);
            footer.setWidthPercentage(100.0f);
            Paragraph footerParagraph = new Paragraph("End of the document. Powered by: Citation Machine beta 2.18");
            PdfPCell footerCell = new PdfPCell((Phrase)footerParagraph);
            footerCell.setHorizontalAlignment(1);
            footerCell.setBackgroundColor(Color.LIGHT_GRAY);
            footer.addCell(footerCell);
            d.add((Element)footer);
        }
        catch (DocumentException e) {
            this.log.error((Object)e);
            return false;
        }
        d.close();
        return true;
    }

    public boolean exportXLS(String file, SearchObject so, int[] sortIndexes) throws FileNotFoundException, IOException {
        if (!so.isCV) {
            int j;
            int rowCounter = 2;
            boolean hasExcLnames = false;
            HSSFWorkbook wb = new HSSFWorkbook();
            CreationHelper createHelper = wb.getCreationHelper();
            Sheet sheet = wb.createSheet("Scientific search PARAMETERS");
            Row row = sheet.createRow(0);
            row.createCell(0).setCellValue(createHelper.createRichTextString(this.headline1));
            Row row2 = sheet.createRow(1);
            row2.createCell(0).setCellValue(createHelper.createRichTextString("Names included"));
            ArrayList<Row> rowList = new ArrayList<Row>();
            for (int i = 0; i < so.getInclNames().length; ++i) {
                rowList.add(sheet.createRow((short)i + 2));
                ((Row)rowList.get(i)).createCell(0).setCellValue(createHelper.createRichTextString(so.getInclNames()[i]));
                ++rowCounter;
            }
            if (so.getExclNames() != null && so.getExclNames().length > 0 && !so.getExclNames()[0].equals("")) {
                hasExcLnames = true;
                Row rowExclNamesTitle = sheet.createRow((int)((short)rowCounter));
                ++rowCounter;
                rowExclNamesTitle.createCell(0).setCellValue(createHelper.createRichTextString("Names excluded"));
                for (j = 0; j < so.getExclNames().length; ++j) {
                    rowList.add(sheet.createRow((int)((short)rowCounter)));
                    ((Row)rowList.get(rowCounter - 3)).createCell(0).setCellValue(createHelper.createRichTextString(so.getExclNames()[j]));
                    ++rowCounter;
                }
            }
            if (so.getAreas() != null) {
                if (so.getAreas().length > 0 && !so.getAreas()[0].equals("")) {
                    Row rowAreas = sheet.createRow((int)((short)rowCounter));
                    ++rowCounter;
                    rowAreas.createCell(0).setCellValue(createHelper.createRichTextString("Search areas"));
                }
                int delay = 3;
                if (hasExcLnames) {
                    delay = 4;
                }
                for (j = 0; j < so.getAreas().length; ++j) {
                    rowList.add(sheet.createRow((int)((short)rowCounter)));
                    ((Row)rowList.get(rowCounter - delay)).createCell(0).setCellValue(createHelper.createRichTextString(so.getAreas()[j]));
                    ++rowCounter;
                }
            }
            String from_to = "";
            if (so.getYearFrom() > 0) {
                from_to = from_to + so.getYearFrom();
            }
            if (so.getYearTo() > 0) {
                from_to = from_to + " - " + so.getYearTo();
            }
            if (!from_to.equals("")) {
                Row rowFromTo = sheet.createRow((int)((short)rowCounter));
                rowFromTo.createCell(0).setCellValue(createHelper.createRichTextString("Search between"));
                Row rowFromToText = sheet.createRow((int)((short)(++rowCounter)));
                ++rowCounter;
                rowFromToText.createCell(0).setCellValue(createHelper.createRichTextString(from_to));
            }
            Row rowDate = sheet.createRow((int)((short)rowCounter));
            rowDate.createCell(0).setCellValue(createHelper.createRichTextString("Search was performed at"));
            Row rowDateText = sheet.createRow((int)((short)(++rowCounter)));
            ++rowCounter;
            rowDateText.createCell(0).setCellValue(createHelper.createRichTextString(so.getSearchDate().toString()));
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("m/d/yy h:mm"));
            rowDateText.getCell(0).setCellStyle(cellStyle);
            Sheet sheetResults = wb.createSheet("Scientific search RESULTS");
            Row rowR_Header = sheetResults.createRow(0);
            int extraColumnNum = so.getSearchResults().get(0).getExtraColumnElementArray().size();
            rowR_Header.createCell(0).setCellValue(createHelper.createRichTextString("rank"));
            rowR_Header.createCell(1).setCellValue(createHelper.createRichTextString("title"));
            rowR_Header.createCell(2).setCellValue(createHelper.createRichTextString("authors"));
            rowR_Header.createCell(3).setCellValue(createHelper.createRichTextString("cites"));
            rowR_Header.createCell(4).setCellValue(createHelper.createRichTextString("self-citations"));
            rowR_Header.createCell(5).setCellValue(createHelper.createRichTextString("publisher"));
            rowR_Header.createCell(6).setCellValue(createHelper.createRichTextString("media"));
            rowR_Header.createCell(7).setCellValue(createHelper.createRichTextString("year"));
            rowR_Header.createCell(8).setCellValue(createHelper.createRichTextString("It's mine"));
            for (int k = 0; k < extraColumnNum; ++k) {
                rowR_Header.createCell(8 + k + 1).setCellValue(createHelper.createRichTextString(so.getSearchResults().get(0).getExtraColumnElementArray().get(k).getName()));
            }
            for (int i = 0; i < sortIndexes.length; ++i) {
                Row row_result = sheetResults.createRow((short)i + 1);
                row_result.createCell(0).setCellValue((double)so.getSearchResults().get(sortIndexes[i]).getRank());
                row_result.createCell(1).setCellValue(createHelper.createRichTextString(so.getSearchResults().get(sortIndexes[i]).getTitle()));
                ArrayList<String> authors = so.getSearchResults().get(sortIndexes[i]).getAuthors();
                String authorString = "";
                for (int l = 0; l < authors.size(); ++l) {
                    authorString = l < authors.size() - 1 ? authorString + authors.get(l) + ";" : authorString + authors.get(l);
                }
                row_result.createCell(2).setCellValue(createHelper.createRichTextString(authorString));
                row_result.createCell(3).setCellValue((double)so.getSearchResults().get(sortIndexes[i]).getCitNum());
                row_result.createCell(4).setCellValue((double)so.getSearchResults().get(sortIndexes[i]).getSelfCitNum());
                row_result.createCell(5).setCellValue(createHelper.createRichTextString(so.getSearchResults().get(sortIndexes[i]).getPublisher()));
                row_result.createCell(6).setCellValue(createHelper.createRichTextString(so.getSearchResults().get(sortIndexes[i]).getMedia()));
                row_result.createCell(7).setCellValue((double)so.getSearchResults().get(sortIndexes[i]).getYear());
                row_result.createCell(8).setCellValue(so.getSearchResults().get(sortIndexes[i]).isMine());
                for (int b = 0; b < extraColumnNum; ++b) {
                    if (so.getSearchResults().get(sortIndexes[i]).getExtraColumnElementArray().get(b).getType() == ExtraColumnElement.Type.TEXT) {
                        row_result.createCell(8 + b + 1).setCellValue(so.getSearchResults().get(sortIndexes[i]).getExtraColumnElementArray().get(b).getContent());
                        continue;
                    }
                    row_result.createCell(8 + b + 1).setCellValue(so.getSearchResults().get(sortIndexes[i]).getExtraColumnElementArray().get(b).isIsTrue());
                }
            }
            sheet.autoSizeColumn(0);
            sheetResults.autoSizeColumn(0);
            sheetResults.autoSizeColumn(1);
            sheetResults.autoSizeColumn(2);
            sheetResults.autoSizeColumn(3);
            sheetResults.autoSizeColumn(4);
            sheetResults.autoSizeColumn(5);
            sheetResults.autoSizeColumn(6);
            sheetResults.autoSizeColumn(7);
            sheetResults.autoSizeColumn(8);
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        } else {
            HSSFWorkbook wb = new HSSFWorkbook();
            CreationHelper createHelper = wb.getCreationHelper();
            Sheet sheetResults = wb.createSheet("Scientific search RESULTS");
            Row rowR_Header = sheetResults.createRow(0);
            int extraColumnNum = so.getSearchResults().get(0).getExtraColumnElementArray().size();
            rowR_Header.createCell(0).setCellValue(createHelper.createRichTextString("rank"));
            rowR_Header.createCell(1).setCellValue(createHelper.createRichTextString("title"));
            rowR_Header.createCell(2).setCellValue(createHelper.createRichTextString("authors"));
            rowR_Header.createCell(3).setCellValue(createHelper.createRichTextString("cites"));
            rowR_Header.createCell(4).setCellValue(createHelper.createRichTextString("self-citations"));
            rowR_Header.createCell(5).setCellValue(createHelper.createRichTextString("publisher"));
            rowR_Header.createCell(6).setCellValue(createHelper.createRichTextString("media"));
            rowR_Header.createCell(7).setCellValue(createHelper.createRichTextString("year"));
            ArrayList resultList = new ArrayList();
            for (int i = 0; i < sortIndexes.length; ++i) {
                Row row_result = sheetResults.createRow((short)i + 1);
                row_result.createCell(0).setCellValue((double)so.getSearchResults().get(sortIndexes[i]).getRank());
                row_result.createCell(1).setCellValue(createHelper.createRichTextString(so.getSearchResults().get(sortIndexes[i]).getTitle()));
                ArrayList<String> authors = so.getSearchResults().get(sortIndexes[i]).getAuthors();
                String authorString = "";
                for (int l = 0; l < authors.size(); ++l) {
                    authorString = l < authors.size() - 1 ? authorString + authors.get(l) + ";" : authorString + authors.get(l);
                }
                row_result.createCell(2).setCellValue(createHelper.createRichTextString(authorString));
                row_result.createCell(3).setCellValue((double)so.getSearchResults().get(sortIndexes[i]).getCitNum());
                row_result.createCell(4).setCellValue((double)so.getSearchResults().get(sortIndexes[i]).getSelfCitNum());
                row_result.createCell(5).setCellValue(createHelper.createRichTextString(so.getSearchResults().get(sortIndexes[i]).getPublisher()));
                row_result.createCell(6).setCellValue(createHelper.createRichTextString(so.getSearchResults().get(sortIndexes[i]).getMedia()));
                row_result.createCell(7).setCellValue((double)so.getSearchResults().get(sortIndexes[i]).getYear());
            }
            sheetResults.autoSizeColumn(0);
            sheetResults.autoSizeColumn(1);
            sheetResults.autoSizeColumn(2);
            sheetResults.autoSizeColumn(3);
            sheetResults.autoSizeColumn(4);
            sheetResults.autoSizeColumn(5);
            sheetResults.autoSizeColumn(6);
            sheetResults.autoSizeColumn(7);
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        return true;
    }
}

