/*
 * Decompiled with CFR 0.152.
 */
package CM.core;

import CM.core.NoResultsException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Parser {
    private static Logger log = Logger.getLogger(Parser.class);

    public static int getContNum(String data) throws NoResultsException {
        int contentNum = 0;
        if (!data.contains("did not match any articles")) {
            if (data.contains("<b>1</b> - <b>100</b> of about")) {
                int begin = data.indexOf("about ") + 9;
                int end = 0;
                if (data.contains("</b> for <b>author:")) {
                    end = data.indexOf("</b> for <b>author:");
                } else {
                    String tmpData = data.substring(0, data.indexOf("</b>.", data.indexOf("<b>1</b> - <b>100</b> of about")));
                    end = tmpData.length();
                }
                String tmpContentNUM = data.substring(begin, end);
                tmpContentNUM = tmpContentNUM.replace(',', '0');
                try {
                    contentNum = new Integer(tmpContentNUM);
                }
                catch (NumberFormatException ex) {
                    log.error((Object)ex);
                }
            } else {
                int begin = data.indexOf("of <b>", data.indexOf("Results")) + 6;
                int end = data.indexOf("</b>", begin);
                String stringNum = data.substring(begin, end);
                try {
                    contentNum = new Integer(stringNum);
                }
                catch (NumberFormatException ex) {
                    log.error((Object)ex);
                }
            }
        } else {
            NoResultsException nre = new NoResultsException("There are no any result page according to this search");
            throw nre;
        }
        return contentNum;
    }

    public ArrayList<String> breakLines(String data) {
        ArrayList<String> dataList = new ArrayList<String>();
        String[] TMPArray = data.split("\n");
        for (int i = 0; i < TMPArray.length; ++i) {
            dataList.add(TMPArray[i]);
        }
        return dataList;
    }

    public String getTitle(String record) {
        String title = "NA";
        int begin = 0;
        int end = 0;
        if (record.contains("class=\"y")) {
            begin = record.indexOf(">", record.indexOf("class=\"y")) + 1;
            end = record.indexOf("<", begin);
            title = record.substring(begin, end);
        }
        if (record.contains("class=y")) {
            begin = record.indexOf(">", record.indexOf("class=y")) + 1;
            end = record.indexOf("<", begin);
            title = record.substring(begin, end);
        } else if (record.contains("[CITATION]")) {
            begin = record.indexOf(">", record.indexOf("[CITATION]")) + 1;
            end = record.indexOf("<", begin);
            title = record.substring(begin, end);
        }
        if (record.contains("[BOOK]")) {
            begin = record.indexOf(">", record.indexOf("[BOOK]")) + 1;
            end = record.indexOf("<", begin);
            title = record.substring(begin, end);
        }
        title = title.replaceAll("&hellip", "...");
        return title;
    }

    public String getLink(String record) {
        String link = "NA";
        int begin = 0;
        if (record.contains("class=\"y") && (record = record.substring(0, record.indexOf("class=\"y"))).contains("href=")) {
            begin = record.indexOf("href=") + 6;
            link = record.substring(begin, record.length() - 2);
        }
        if (record.contains("class=y") && (record = record.substring(0, record.indexOf("class=y"))).contains("href=")) {
            begin = record.indexOf("href=") + 6;
            link = record.substring(begin, record.length() - 2);
        }
        return link;
    }

    public ArrayList<String> getAuthors(String record) {
        ArrayList<String> authors = new ArrayList<String>();
        String authorString = "";
        int begin = 0;
        int end = 0;
        if (record.contains("class=gs_a")) {
            begin = record.indexOf(">", record.indexOf("class=gs_a")) + 1;
            end = record.contains(" -") ? record.indexOf(" -", begin) : record.length();
            authorString = record.substring(begin, end);
            authorString = authorString.replaceAll("<b>", "");
            if ((authorString = authorString.replaceAll("</b>", "")).contains("</span>")) {
                authorString = authorString.substring(0, authorString.indexOf("</span>"));
            }
        }
        String[] authorArray = authorString.split(",");
        for (int i = 0; i < authorArray.length; ++i) {
            if (authorArray[i].charAt(0) == ' ' && authorArray[i].length() > 2) {
                authorArray[i] = authorArray[i].substring(1, authorArray[i].length());
            }
            authors.add(authorArray[i].replaceAll("&hellip", "..."));
        }
        return authors;
    }

    public int getCitNum(String record) throws NumberFormatException {
        int citNum = 0;
        int begin = 0;
        int end = 0;
        if (record.contains("Cited by")) {
            begin = record.indexOf(" ", record.indexOf("Cited by")) + 1 + 3;
            end = record.indexOf("<", begin);
            try {
                citNum = new Integer(record.substring(begin, end));
            }
            catch (NumberFormatException e) {
                log.error((Object)"Unable to convert Citnum to int", (Throwable)e);
            }
        }
        return citNum;
    }

    public String getCitLink(String record) {
        String citLink = "NA";
        int begin = 0;
        int end = 0;
        if (record.contains("Cited by")) {
            begin = record.indexOf("/scholar?");
            end = record.indexOf(">", begin) - 1;
            citLink = record.substring(begin, end);
        }
        if (citLink.contains("/scholar?cites=")) {
            int b = citLink.indexOf("?cites=") + 7;
            citLink = citLink.substring(b, citLink.indexOf("&", b));
        } else {
            citLink = "NA";
        }
        return citLink;
    }

    public int getYear(String record) throws NumberFormatException {
        int year = 0;
        int begin = 0;
        int end = 0;
        String yearString = "0";
        if (record.contains("class=\"a")) {
            record = record.substring(record.indexOf("class=\"a"));
        }
        if (record.contains("class=a")) {
            record = record.substring(record.indexOf("class=a"));
        }
        if (this.count(record, " - ") > 1) {
            begin = record.indexOf(" - ") + 3;
            if (this.count(record = record.substring(begin, end = record.indexOf(" - ", begin)), ",") > 1) {
                begin = record.lastIndexOf(",") + 2;
                end = record.contains("<") ? record.indexOf("<", begin) : record.length();
                try {
                    yearString = record.substring(begin, end);
                }
                catch (StringIndexOutOfBoundsException e) {
                    log.error((Object)e);
                }
            } else if (this.count(record, ",") == 1) {
                begin = record.indexOf(",") + 2;
                end = record.contains("<") ? record.indexOf("<", begin) : record.length();
                try {
                    yearString = record.substring(begin, end);
                }
                catch (StringIndexOutOfBoundsException e) {
                    log.error((Object)e);
                }
            }
        } else {
            yearString = "0";
        }
        year = new Integer(yearString);
        return year;
    }

    public String getPublication(String record) {
        String publication = "NA";
        int begin = 0;
        int end = 0;
        if (record.contains("class=\"a")) {
            record = record.substring(record.indexOf("class=\"a"));
        }
        if (record.contains("class=a")) {
            record = record.substring(record.indexOf("class=a"));
        }
        if (this.count(record, " - ") > 1) {
            begin = record.indexOf(" - ") + 3;
            if ((record = record.substring(begin, end = record.indexOf(" - ", begin))).contains(",")) {
                end = record.indexOf(",");
                publication = record.substring(0, end);
            }
        } else if (record.contains(" - ")) {
            begin = record.indexOf(" - ") + 3;
            if ((record = record.substring(begin)).contains(",")) {
                end = record.indexOf(",");
                publication = record.substring(0, end);
            } else {
                publication = record;
            }
        }
        if (publication.contains("<")) {
            end = publication.indexOf("<");
            publication = publication.substring(0, end);
        }
        publication = publication.replaceAll("&hellip;", "...").replace("&amp;", "&");
        return publication;
    }

    public String getPublisher(String record) {
        String publisher = "NA";
        boolean begin = false;
        boolean end = false;
        record = record.replaceAll("<span class=\"a\">\u25ba", "");
        if ((record = record.replaceAll("<span class=a>\u25ba", "")).contains("class=\"a")) {
            record = record.substring(record.indexOf("class=\"a"));
        }
        if (record.contains("class=a")) {
            record = record.substring(record.indexOf("class=a"));
        }
        if (record.contains("</span>")) {
            record = record.substring(0, record.indexOf("</span>"));
        }
        if (this.count(record, " - ") > 1) {
            publisher = record.substring(record.lastIndexOf(" - ") + 3);
        }
        return publisher;
    }

    int count(String data, String searchFor) {
        int len = searchFor.length();
        int result = 0;
        if (len > 0) {
            int start = data.indexOf(searchFor);
            while (start != -1) {
                ++result;
                start = data.indexOf(searchFor, start + len);
            }
        }
        return result;
    }

    int getSelfCitNum(String data, String[] exprArray) {
        boolean isFirst = true;
        ArrayList<String> nameVariants = new ArrayList<String>();
        for (int i = 0; i < exprArray.length; ++i) {
            if (isFirst) {
                nameVariants.add(exprArray[i].toUpperCase().replaceAll(" ", ""));
                isFirst = false;
                continue;
            }
            if (nameVariants.contains(exprArray[i].toUpperCase().replaceAll(" ", ""))) continue;
            nameVariants.add(exprArray[i].toUpperCase().replaceAll(" ", ""));
        }
        int count = 0;
        data = data.toUpperCase();
        data = data.replaceAll(" ", "");
        for (int i = 0; i < nameVariants.size(); ++i) {
            int tmpCount = 0;
            String[] tmpArray = data.split((String)nameVariants.get(i));
            tmpCount = tmpArray.length;
            if (tmpCount > 0) {
                --tmpCount;
            }
            count += tmpCount;
        }
        return count;
    }
}

