/*
 * Decompiled with CFR 0.152.
 */
package CM.core;

import CM.Configuration.Configuration;
import CM.Configuration.Settings;
import CM.GUI.CMFinisEvent;
import CM.GUI.CMFinishListener;
import CM.GUI.MyEvent;
import CM.GUI.MyEventListener;
import CM.GUI.cmGUIView;
import CM.Tools.FileWork;
import CM.Tools.PageProvider;
import CM.core.Content;
import CM.core.GoogleScholarParser;
import CM.core.NoResultsException;
import CM.core.SearchObject;
import CM.core.SearchParameters;
import CM.core.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class CM_Main
implements Runnable {
    private Logger log = Logger.getLogger(CM_Main.class);
    Settings settings = Settings.getInstance();
    Random rand = new Random();
    private int delay;
    private int delayRandMin;
    private int delayRandMax;
    private int waitDelayRandMin;
    private int waitDelayRandMax;
    private int minPageNum;
    private int maxPageNum;
    private Configuration config;
    private String cacheFolder = "cache";
    private SearchObject updatedSo;
    private SearchParameters parameters;
    PageProvider pageProvider = new PageProvider();
    GoogleScholarParser parser = new GoogleScholarParser();
    boolean isBanned = false;
    ArrayList<String> contentsList = new ArrayList();
    String recordSeparator = "<div class=gs_r>";
    protected EventListenerList listenerList = new EventListenerList();
    SearchObject so;

    public CM_Main(SearchParameters parameters, SearchObject updatedSo) {
        this.config = Configuration.getInstance();
        this.updatedSo = this.config.isUpdateSession() ? updatedSo : null;
        this.init();
        this.parameters = parameters;
    }

    private void init() {
        this.delay = this.config.getDelay();
        this.delayRandMin = this.config.getDelayRandMin();
        this.delayRandMax = this.config.getDelayRandMax();
        this.waitDelayRandMin = this.config.getWaitDelayRandMin();
        this.waitDelayRandMax = this.config.getWaitDelayRandMax();
        this.minPageNum = this.config.getMinPageNum();
        this.maxPageNum = this.config.getMaxPageNum();
    }

    public void addMyEventListener(MyEventListener listener) {
        this.listenerList.add(MyEventListener.class, listener);
    }

    public void removeMyEventListener(MyEventListener listener) {
        this.listenerList.remove(MyEventListener.class, listener);
    }

    void fireMyEvent(MyEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != MyEventListener.class) continue;
            ((MyEventListener)listeners[i + 1]).myEventOccurred(evt);
        }
    }

    public void addCMFinishListener(CMFinishListener listener) {
        this.listenerList.add(CMFinishListener.class, listener);
    }

    public void removeCMFinishListener(CMFinishListener listener) {
        this.listenerList.remove(CMFinishListener.class, listener);
    }

    void fireCMFinishListener(CMFinisEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != CMFinishListener.class) continue;
            ((CMFinishListener)listeners[i + 1]).CMFinisEvent(evt);
        }
    }

    public int getContentNum(SearchParameters parameters) {
        int contentNum = 0;
        String tmpPage = "";
        tmpPage = this.pageProvider.getPage(parameters, 0);
        if (tmpPage.equals("ERROR_CODE_503")) {
            this.isBanned = true;
            return -1;
        }
        if (tmpPage.equals("NO_NETWORK")) {
            return -2;
        }
        try {
            contentNum = GoogleScholarParser.getContNum(tmpPage);
        }
        catch (NoResultsException e1) {
            cmGUIView.setProgressbarText("There were no results found!");
            this.logparamaters();
            this.log.info((Object)"No results", (Throwable)e1);
            return 0;
        }
        return contentNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchObject search() {
        SearchObject so = new SearchObject();
        ArrayList<Content> Results = new ArrayList<Content>();
        int pageNum = 0;
        int contentNum = 0;
        String tmpPage = "";
        try {
            tmpPage = this.pageProvider.getPage(this.parameters, 0);
            String[] contentsArray = tmpPage.split(this.recordSeparator);
            for (int i = 1; i < contentsArray.length; ++i) {
                this.contentsList.add(contentsArray[i]);
            }
            contentNum = GoogleScholarParser.getContNum(tmpPage);
        }
        catch (NoResultsException e1) {
            this.log.info((Object)"No results", (Throwable)e1);
            this.logparamaters();
        }
        finally {
            tmpPage = "";
        }
        pageNum = contentNum / 100;
        if (pageNum >= 10) {
            pageNum = 9;
        }
        for (int i = 1; i <= pageNum; ++i) {
            tmpPage = this.pageProvider.getPage(this.parameters, i);
            this.fireMyEvent(new MyEvent(this));
            String[] contentsArray = tmpPage.split(this.recordSeparator);
            for (int j = 1; j < contentsArray.length; ++j) {
                this.contentsList.add(contentsArray[j]);
            }
            try {
                Thread.sleep(this.delay);
                continue;
            }
            catch (InterruptedException ex) {
                this.log.error((Object)"delay sleep error", (Throwable)ex);
            }
        }
        Time _time = new Time();
        int finalTime = 0;
        int absPageNum = this.contentsList.size();
        int pageDividerNum = this.minPageNum;
        int[] delayArray = new int[this.contentsList.size()];
        if (absPageNum < this.minPageNum) {
            pageDividerNum = absPageNum;
            absPageNum = 0;
        } else {
            absPageNum -= pageDividerNum;
        }
        int pageCounter = 0;
        for (int k = 0; k < this.contentsList.size(); ++k) {
            if (pageCounter < pageDividerNum) {
                int tmp_delay = this.delayRandMax - this.delayRandMin;
                delayArray[k] = tmp_delay > 0 ? this.rand.nextInt(tmp_delay) + this.delayRandMin : 0;
                finalTime += delayArray[k];
                ++pageCounter;
                continue;
            }
            int tmp_delayRand = this.waitDelayRandMax - this.waitDelayRandMin;
            delayArray[k] = tmp_delayRand > 0 ? this.rand.nextInt(tmp_delayRand) + this.waitDelayRandMin : 0;
            finalTime += delayArray[k];
            int tmp_pageNum = this.maxPageNum - this.minPageNum;
            if (tmp_pageNum < 0) {
                tmp_pageNum = 0;
            }
            pageDividerNum = this.rand.nextInt(tmp_pageNum) + this.minPageNum;
            if (absPageNum < this.minPageNum) {
                pageDividerNum = absPageNum;
                absPageNum = 0;
            } else {
                absPageNum -= pageDividerNum;
            }
            pageCounter = 0;
        }
        _time.setBaseTime(finalTime);
        cmGUIView.setProgressbarText("Estimated time remained: " + _time.getMinutes() + " minutes ");
        for (int i = 0; i < this.contentsList.size(); ++i) {
            Content result = new Content();
            String tmpRecord = "";
            if (this.contentsList.get(i).contains("<div class=\"n\">")) {
                tmpRecord = this.contentsList.get(i).substring(0, this.contentsList.get(i).indexOf("<div class=\"n\">"));
                this.contentsList.set(i, tmpRecord);
            }
            if (this.contentsList.get(i).contains("<div class=n>")) {
                tmpRecord = this.contentsList.get(i).substring(0, this.contentsList.get(i).indexOf("<div class=n>"));
                this.contentsList.set(i, tmpRecord);
            }
            result.setContentId("10");
            result.setRank(i);
            result.setTitle(this.parser.getTitle(this.contentsList.get(i)));
            result.setLink(this.parser.getLink(this.contentsList.get(i)));
            ArrayList<String> authorsArrayList = this.parser.getAuthors(this.contentsList.get(i));
            result.setAuthors(authorsArrayList);
            String citLink = this.parser.getCitLink(this.contentsList.get(i));
            result.setCitLink(citLink);
            String rawSelfCitPages = "";
            int citNum = this.parser.getCitNum(this.contentsList.get(i));
            result.setCitNum(citNum);
            if (this.parameters.isIsSelfCitationFiletringEnabled()) {
                so.setIsSelfcitationFiltered(true);
                try {
                    if (!citLink.equals("NA")) {
                        for (int _delay = delayArray[i]; _delay > 0; _delay -= 1000) {
                            cmGUIView.setProgressbarText("Estimated time remained: " + _time.getMinutes() + " minutes ");
                            _time.decreaseTime();
                            Thread.sleep(1000L);
                        }
                        int num = 0;
                        num = citNum <= 100 ? 0 : citNum / 100;
                        if (num >= 10) {
                            num = 9;
                        }
                        if (num > 0) {
                            rawSelfCitPages = this.pageProvider.getPage(this.buildCitLink(citLink, 0));
                            for (int h = 1; h < num + 1; ++h) {
                                rawSelfCitPages = rawSelfCitPages + this.pageProvider.getPage(this.buildCitLink(citLink, h));
                            }
                        } else {
                            rawSelfCitPages = this.pageProvider.getPage(this.buildCitLink(citLink, 0));
                        }
                        if (rawSelfCitPages.equals("ERROR_CODE_503")) {
                            this.isBanned = true;
                            break;
                        }
                        if (this.parameters.isIsSelfCitationFiletringEnabled()) {
                            result.setSelfCitNum(this.parser.getSelfCitNum(rawSelfCitPages, this.parameters.getIncludeArray()));
                        }
                    } else {
                        result.setSelfCitNum(0);
                    }
                    this.fireMyEvent(new MyEvent(this));
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
            try {
                result.setYear(this.parser.getYear(this.contentsList.get(i)));
            }
            catch (NumberFormatException nex) {
                result.setYear(-1);
            }
            result.setPublisher(this.parser.getPublisher(this.contentsList.get(i)));
            result.setMedia(this.parser.getPublication(this.contentsList.get(i)));
            Results.add(result);
        }
        String[] areas = this.parameters.getAreasArray();
        String[] inclNames = this.parameters.getIncludeArray();
        String[] exclNames = this.parameters.getExcludeArray();
        so.searchDate = new Date();
        so.setAreas(areas);
        so.setInclNames(inclNames);
        so.setExclNames(exclNames);
        so.setYearFrom(this.parameters.getIntFrom());
        so.setYearTo(this.parameters.getIntTo());
        so.setSearchResults(Results);
        if (this.isBanned) {
            this.log.error((Object)"Access denied to the service!, the settings were:");
            this.log.error((Object)("delay :" + this.config.getDelay()));
            this.log.error((Object)("DelayRandMax :" + this.config.getDelayRandMax()));
            this.log.error((Object)("DelayRandMin :" + this.config.getDelayRandMin()));
            this.log.error((Object)("WaitDelayRandMax :" + this.config.getWaitDelayRandMax()));
            this.log.error((Object)("WaitDelayRandMin :" + this.config.getWaitDelayRandMin()));
            this.log.error((Object)("MaxPageNum :" + this.config.getMaxPageNum()));
            this.log.error((Object)("MinPageNum :" + this.config.getMinPageNum()));
            this.log.error((Object)"Results data");
            this.log.error((Object)("InclNames :" + this.parameters.getInclNames()));
            this.log.error((Object)("Exclnames :" + this.parameters.getExclnames()));
            this.log.error((Object)("From :" + this.parameters.getFrom()));
            this.log.error((Object)("To :" + this.parameters.getTo()));
            this.log.error((Object)("Areas :" + this.parameters.getAreas()));
            this.log.error((Object)("IsSelfCitationFiletringEnabled :" + this.parameters.isIsSelfCitationFiletringEnabled()));
            this.log.error((Object)"END of banned stack");
            cmGUIView.setProgressbarText("Access denied to the service!");
            cmGUIView.showBannedDialog();
        } else {
            int fileNum;
            cmGUIView.setProgressbarText("P");
            cmGUIView.disposeProgressBarPanel();
            ArrayList<String> list = FileWork.getFilePathsInFolder("cache");
            int counter = 0;
            for (fileNum = list.size(); fileNum > this.config.getMaxChachedFileNum(); --fileNum) {
                FileWork.delete(list.get(counter));
                ++counter;
            }
            FileWork.write(so, this.cacheFolder + "/cache" + (fileNum + 1) + ".scl", false);
        }
        return so;
    }

    public SearchObject getSo() {
        return this.so;
    }

    public SearchObject searchInCache() {
        Iterator<String> files = FileWork.getFilePathsInFolder(this.cacheFolder).iterator();
        SearchObject cachedSearchObject = null;
        int counter = 0;
        while (files.hasNext()) {
            SearchObject tmp = FileWork.readSearchObjectfromFile(files.next());
            if (!this.isSnapshotAdequate(tmp)) continue;
            if (counter == 0) {
                cachedSearchObject = tmp;
                ++counter;
                continue;
            }
            if (!cachedSearchObject.getSearchDate().after(tmp.getSearchDate())) continue;
            cachedSearchObject = tmp;
        }
        return cachedSearchObject;
    }

    @Override
    public void run() {
        this.so = this.search();
        cmGUIView.setProgressbarText("Please wait until the results being processed and shown up.");
        if (this.updatedSo != null) {
            this.so.copyUserSettings(this.updatedSo);
        }
        this.fireCMFinishListener(new CMFinisEvent(this));
    }

    private boolean compInclNames(String[] cachedInclNames) {
        boolean success = true;
        boolean[] successes = new boolean[this.parameters.getIncludeArray().length];
        block0: for (int i = 0; i < this.parameters.getIncludeArray().length; ++i) {
            successes[i] = false;
            for (int j = 0; j < cachedInclNames.length; ++j) {
                if (!this.parameters.getIncludeArray()[i].toLowerCase().equals(cachedInclNames[j].toLowerCase())) continue;
                successes[i] = true;
                continue block0;
            }
        }
        for (int k = 0; k < successes.length; ++k) {
            if (successes[k]) continue;
            success = false;
            break;
        }
        return success;
    }

    private boolean compExclNames(String[] cachedExclNames) {
        boolean success = true;
        boolean[] successes = new boolean[this.parameters.getExcludeArray().length];
        block0: for (int i = 0; i < this.parameters.getExcludeArray().length; ++i) {
            successes[i] = false;
            for (int j = 0; j < cachedExclNames.length; ++j) {
                if (!this.parameters.getExcludeArray()[i].toLowerCase().equals(cachedExclNames[j].toLowerCase())) continue;
                successes[i] = true;
                continue block0;
            }
        }
        for (int k = 0; k < successes.length; ++k) {
            if (successes[k]) continue;
            success = false;
            break;
        }
        return success;
    }

    private boolean compAreas(String[] cachedAreas) {
        boolean success = true;
        boolean[] successes = new boolean[this.parameters.getAreasArray().length];
        if (cachedAreas.length > 0) {
            block0: for (int i = 0; i < this.parameters.getAreasArray().length; ++i) {
                successes[i] = false;
                for (int j = 0; j < cachedAreas.length; ++j) {
                    if (!this.parameters.getAreasArray()[i].toLowerCase().equals(cachedAreas[j].toLowerCase())) continue;
                    successes[i] = true;
                    continue block0;
                }
            }
            for (int k = 0; k < successes.length; ++k) {
                if (successes[k]) continue;
                success = false;
                break;
            }
        } else {
            success = true;
        }
        return success;
    }

    private boolean compFrom(int cached) {
        boolean success = true;
        int param = 0;
        if (!this.parameters.getFrom().equals("")) {
            param = new Integer(this.parameters.getFrom().substring(8));
        }
        if (cached != param && cached > 0 && param < cached) {
            success = false;
        }
        return success;
    }

    private boolean compTo(int cached) {
        boolean success = true;
        int param = 0;
        if (!this.parameters.getFrom().equals("")) {
            param = new Integer(this.parameters.getFrom().substring(8));
        }
        if (cached != param && cached > 0 && param > cached) {
            success = false;
        }
        return success;
    }

    private boolean isSnapshotAdequate(SearchObject toTestObj) {
        boolean adequate = true;
        if (toTestObj.getSearchDate().before(this.config.getNoChacheBefore())) {
            adequate = false;
        }
        if (!this.compAreas(toTestObj.getAreas())) {
            adequate = false;
        }
        if (!this.compExclNames(toTestObj.getExclNames())) {
            adequate = false;
        }
        if (!this.compInclNames(toTestObj.getInclNames())) {
            adequate = false;
        }
        if (!this.compFrom(toTestObj.getYearFrom())) {
            adequate = false;
        }
        if (!this.compTo(toTestObj.getYearTo())) {
            adequate = false;
        }
        if (!toTestObj.isIsSelfcitationFiltered() == this.parameters.isIsSelfCitationFiletringEnabled()) {
            adequate = false;
        }
        return adequate;
    }

    private void logparamaters() {
        int i;
        this.log.info((Object)"No results data-------------------------------");
        for (i = 0; i < this.parameters.getIncludeArray().length; ++i) {
            this.log.info((Object)("inclName: " + this.parameters.getIncludeArray()[i]));
        }
        for (i = 0; i < this.parameters.getExcludeArray().length; ++i) {
            this.log.info((Object)("exclName: " + this.parameters.getExcludeArray()[i]));
        }
        for (i = 0; i < this.parameters.getAreasArray().length; ++i) {
            this.log.info((Object)("Areas: " + this.parameters.getAreasArray()[i]));
        }
        this.log.info((Object)("from: " + this.parameters.getIntFrom() + ", to: " + this.parameters.getIntTo()));
        this.log.info((Object)"END No results data-------------------------------");
    }

    private String buildCitLink(String citLink, int num) {
        return "http://scholar.google.com/scholar?start=" + num * 100 + "&hl=en&num=100&as_sdt=2000&cites=" + citLink;
    }
}

