/*
 * Decompiled with CFR 0.152.
 */
package CM.core;

import CM.Configuration.Configuration;
import CM.Configuration.Settings;
import CM.GUI.CM_CV_UpdateFinishEvent;
import CM.GUI.CM_CV_UpdateFinishEventListener;
import CM.GUI.MyEvent;
import CM.GUI.MyEventListener;
import CM.GUI.cmGUIView;
import CM.Tools.PageProvider;
import CM.core.Content;
import CM.core.GoogleScholarParser;
import CM.core.SearchObject;
import CM.core.Time;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class CM_CV_Update
implements Runnable {
    private Logger log = Logger.getLogger(CM_CV_Update.class);
    private Configuration config;
    private SearchObject so;
    Settings settings = Settings.getInstance();
    Random rand = new Random();
    private int delay;
    private int delayRandMin;
    private int delayRandMax;
    private int waitDelayRandMin;
    private int waitDelayRandMax;
    private int minPageNum;
    private int maxPageNum;
    PageProvider pageProvider = new PageProvider();
    GoogleScholarParser parser = new GoogleScholarParser();
    int[] delayArray;
    int finalTime = 0;
    Time _time = new Time();
    boolean isBanned = false;
    protected EventListenerList listenerList = new EventListenerList();

    public CM_CV_Update(SearchObject so) {
        this.config = Configuration.getInstance();
        this.so = so;
        this.init();
    }

    private void init() {
        this.delay = this.config.getDelay();
        this.delayRandMin = this.config.getDelayRandMin();
        this.delayRandMax = this.config.getDelayRandMax();
        this.waitDelayRandMin = this.config.getWaitDelayRandMin();
        this.waitDelayRandMax = this.config.getWaitDelayRandMax();
        this.minPageNum = this.config.getMinPageNum();
        this.maxPageNum = this.config.getMaxPageNum();
        int absPageNum = this.so.getSearchResults().size();
        int pageDividerNum = this.minPageNum;
        this.delayArray = new int[this.so.getSearchResults().size()];
        if (absPageNum < this.minPageNum) {
            pageDividerNum = absPageNum;
            absPageNum = 0;
        } else {
            absPageNum -= pageDividerNum;
        }
        int pageCounter = 0;
        for (int k = 0; k < this.so.getSearchResults().size(); ++k) {
            if (pageCounter < pageDividerNum) {
                int tmp_delay = this.delayRandMax - this.delayRandMin;
                this.delayArray[k] = tmp_delay > 0 ? this.rand.nextInt(tmp_delay) + this.delayRandMin : 0;
                this.finalTime += this.delayArray[k];
                ++pageCounter;
                continue;
            }
            int tmp_delayRand = this.waitDelayRandMax - this.waitDelayRandMin;
            this.delayArray[k] = tmp_delayRand > 0 ? this.rand.nextInt(tmp_delayRand) + this.waitDelayRandMin : 0;
            this.finalTime += this.delayArray[k];
            int tmp_pageNum = this.maxPageNum - this.minPageNum;
            if (tmp_pageNum < 0) {
                tmp_pageNum = 0;
            }
            pageDividerNum = this.rand.nextInt(tmp_pageNum) + this.minPageNum;
            if (absPageNum < this.minPageNum) {
                pageDividerNum = absPageNum;
                absPageNum = 0;
            } else {
                absPageNum -= pageDividerNum;
            }
            pageCounter = 0;
        }
        this._time.setBaseTime(this.finalTime);
        cmGUIView.setProgressbarText("Estimated time remained: " + this._time.getMinutes() + " minutes ");
    }

    public SearchObject updateCV(SearchObject oldCV) {
        String linkPaperData = "";
        String page = "";
        ArrayList<Content> contentList = oldCV.getSearchResults();
        String rawSelfCitPages = "";
        for (int i = 0; i < contentList.size(); ++i) {
            String citLink = contentList.get(i).getCitLink();
            linkPaperData = "http://scholar.google.com/scholar?cluster=" + citLink + "&hl=en&num=100&as_sdt=2000";
            page = this.pageProvider.getPage(linkPaperData);
            if (page.equals("ERROR_CODE_503")) {
                this.isBanned = true;
                break;
            }
            int citNum = this.parser.getCitNum(page);
            contentList.get(i).setCitNum(citNum);
            if (this.so.isIsSelfcitationFiltered()) {
                try {
                    if (!citLink.equals("NA")) {
                        int num = 0;
                        num = citNum <= 100 ? 0 : citNum / 100;
                        if (num >= 10) {
                            num = 9;
                        }
                        if (num > 0) {
                            rawSelfCitPages = this.pageProvider.getPage(this.buildCitLink(citLink, 0));
                            for (int h = 1; h < num + 1; ++h) {
                                rawSelfCitPages = rawSelfCitPages + this.pageProvider.getPage(this.buildCitLink(citLink, h));
                            }
                        } else {
                            rawSelfCitPages = this.pageProvider.getPage(this.buildCitLink(citLink, 0));
                        }
                        if (rawSelfCitPages.equals("ERROR_CODE_503")) {
                            this.isBanned = true;
                            break;
                        }
                        contentList.get(i).setSelfCitNum(this.parser.getSelfCitNum(rawSelfCitPages, oldCV.getInclNames()));
                    } else {
                        contentList.get(i).setSelfCitNum(0);
                    }
                    this.fireMyEvent(new MyEvent(this));
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
            try {
                for (int _delay = this.delayArray[i]; _delay > 0; _delay -= 1000) {
                    cmGUIView.setProgressbarText("Estimated time remained: " + this._time.getMinutes() + " minutes ");
                    this._time.decreaseTime();
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ex) {
                this.log.error((Object)"delay sleep error", (Throwable)ex);
            }
            this.fireMyEvent(new MyEvent(this));
        }
        oldCV.setSearchResults(contentList);
        if (this.isBanned) {
            this.log.error((Object)"Access denied to the service!, the settings were:");
            this.log.error((Object)"CV update session");
            this.log.error((Object)("delay :" + this.config.getDelay()));
            this.log.error((Object)("DelayRandMax :" + this.config.getDelayRandMax()));
            this.log.error((Object)("DelayRandMin :" + this.config.getDelayRandMin()));
            this.log.error((Object)("WaitDelayRandMax :" + this.config.getWaitDelayRandMax()));
            this.log.error((Object)("WaitDelayRandMin :" + this.config.getWaitDelayRandMin()));
            this.log.error((Object)("MaxPageNum :" + this.config.getMaxPageNum()));
            this.log.error((Object)("MinPageNum :" + this.config.getMinPageNum()));
            this.log.error((Object)("Num of CV items: " + oldCV.getSearchResults().size()));
            this.log.error((Object)("CV self-cit filtering: " + oldCV.isSelfcitationFiltered));
            this.log.error((Object)"END of banned stack");
            cmGUIView.setProgressbarText("Access denied to the service!");
            cmGUIView.showBannedDialog();
        } else {
            cmGUIView.disposeProgressBarPanel();
        }
        return oldCV;
    }

    public SearchObject getSo() {
        return this.so;
    }

    private String buildCitLink(String citLink, int num) {
        return "http://scholar.google.com/scholar?start=" + num * 100 + "&hl=en&num=100&as_sdt=2000&cites=" + citLink;
    }

    @Override
    public void run() {
        this.so = this.updateCV(this.so);
        this.fireCM_CV_UpdateFinishEventListener(new CM_CV_UpdateFinishEvent(this));
    }

    public void addMyEventListener(MyEventListener listener) {
        this.listenerList.add(MyEventListener.class, listener);
    }

    public void removeMyEventListener(MyEventListener listener) {
        this.listenerList.remove(MyEventListener.class, listener);
    }

    void fireMyEvent(MyEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != MyEventListener.class) continue;
            ((MyEventListener)listeners[i + 1]).myEventOccurred(evt);
        }
    }

    public void addCM_CV_UpdateFinishEventListener(CM_CV_UpdateFinishEventListener listener) {
        this.listenerList.add(CM_CV_UpdateFinishEventListener.class, listener);
    }

    public void removeCM_CV_UpdateFinishEventListener(CM_CV_UpdateFinishEventListener listener) {
        this.listenerList.remove(CM_CV_UpdateFinishEventListener.class, listener);
    }

    void fireCM_CV_UpdateFinishEventListener(CM_CV_UpdateFinishEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != CM_CV_UpdateFinishEventListener.class) continue;
            ((CM_CV_UpdateFinishEventListener)listeners[i + 1]).CM_CV_UpdateFinishEvent(evt);
        }
    }
}

