/*
 * Decompiled with CFR 0.152.
 */
package CM.Tools;

import CM.Tools.SettingsSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class Settings {
    private static Settings instance;
    private Properties base = new Properties();
    private Hashtable settings = new Hashtable();
    private String baseFile;
    private String path = "";

    private Settings() {
    }

    public static Settings getInstance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    public synchronized void load(String file, String path) throws IOException {
        this.path = path;
        this.baseFile = file;
        File propFile = new File(file);
        this.base.load(new FileInputStream(propFile));
    }

    public synchronized void save(Properties prop) throws IOException {
        File propFile = new File(this.baseFile);
        prop.store(new FileOutputStream(propFile), "");
    }

    public String getSetting(String key) {
        String index = "";
        String value = null;
        int pos = key.indexOf(".");
        if (pos > -1) {
            index = key.substring(0, pos);
        }
        if (index.equals("") || index.equals("include") || index.equals("directory")) {
            value = this.base.getProperty(key);
            return value;
        }
        key = key.substring(pos + 1);
        SettingsSource temp = this.getSource(index);
        if (temp != null) {
            value = temp.getSetting(key);
        }
        return value;
    }

    public static String get(String key) {
        return Settings.getInstance().getSetting(key);
    }

    private SettingsSource getSource(String index) {
        SettingsSource temp = (SettingsSource)this.settings.get(index);
        if (temp == null) {
            String param = this.base.getProperty("include." + index + ".param");
            String sourceType = this.base.getProperty("include." + index + ".sourceType");
            if (sourceType == null) {
                sourceType = "FileSettings";
            }
            try {
                temp = (SettingsSource)Class.forName("CM.Tools" + sourceType).newInstance();
                temp.load(this.path + param);
                this.settings.put(index, temp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return temp;
    }
}

