/*
 * Decompiled with CFR 0.152.
 */
package CM.Tools;

import CM.core.SearchParameters;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.log4j.Logger;

public class PageProvider {
    private Logger log = Logger.getLogger(PageProvider.class);
    URL url;
    BufferedInputStream is;

    public String getPage(SearchParameters parameters, int pages) {
        String htmlDoc = "";
        HTMLEditorKit kit = new HTMLEditorKit();
        Document doc = ((EditorKit)kit).createDefaultDocument();
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        String tmpUrl = "http://scholar.google.com/scholar?start=" + pages * 100 + "&q=" + parameters.getInclNames() + parameters.getExclnames() + "&hl=en&num=100" + parameters.getFrom() + "" + parameters.getTo() + "" + parameters.getAreas();
        tmpUrl = tmpUrl.replaceAll(" ", "%20").replaceAll("\"", "%22");
        tmpUrl = tmpUrl.replaceAll("\t", "");
        try {
            this.url = new URL(tmpUrl);
        }
        catch (MalformedURLException e1) {
            this.log.error((Object)e1);
        }
        URLConnection uc = null;
        try {
            uc = this.url.openConnection();
        }
        catch (IOException e) {
            this.log.error((Object)e);
        }
        uc.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3");
        try {
            this.is = new BufferedInputStream(uc.getInputStream());
        }
        catch (IOException e) {
            if (e.getMessage().contains("503")) {
                this.log.error((Object)"Haho, Google thinks we are using automated queries we should do something!", (Throwable)e);
                return "ERROR_CODE_503";
            }
            this.log.error((Object)"Network error", (Throwable)e);
            return "NO_NETWORK";
        }
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF8"));
            String ThisLine = "";
            try {
                while ((ThisLine = rd.readLine()) != null) {
                    htmlDoc = htmlDoc + ThisLine + '\n';
                }
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)e);
        }
        return htmlDoc;
    }

    public String getPage(String URL2) {
        String htmlDoc;
        block11: {
            htmlDoc = "";
            HTMLEditorKit kit = new HTMLEditorKit();
            Document doc = ((EditorKit)kit).createDefaultDocument();
            doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            URL2 = URL2.replaceAll(" ", "%20").replaceAll("\"", "%22");
            try {
                this.url = new URL(URL2);
            }
            catch (MalformedURLException e1) {
                this.log.error((Object)e1);
                return null;
            }
            URLConnection uc = null;
            try {
                uc = this.url.openConnection();
            }
            catch (IOException e) {
                this.log.error((Object)"No acces to the search engine", (Throwable)e);
                return null;
            }
            uc.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-GB; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3");
            try {
                this.is = new BufferedInputStream(uc.getInputStream());
            }
            catch (IOException e) {
                this.log.error((Object)e);
                if (!e.getMessage().contains("503")) break block11;
                this.log.error((Object)"Haho, Google thinks we are using automated queries we should do something!");
                return "ERROR_CODE_503";
            }
        }
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)this.is, "UTF8"));
            String ThisLine = "";
            try {
                while ((ThisLine = rd.readLine()) != null) {
                    htmlDoc = htmlDoc + ThisLine + '\n';
                }
            }
            catch (IOException e) {
                this.log.error((Object)e);
                return null;
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)e);
            return null;
        }
        return htmlDoc;
    }
}

