/*
 * Decompiled with CFR 0.152.
 */
package CM.Tools;

import CM.core.SearchObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FileWork {
    private static Logger log = Logger.getLogger(FileWork.class);

    public static void write(String data, String filepath, boolean append) throws IOException {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filepath, append));
            out.write(data + "\n");
            out.close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public static void write(SearchObject so, String filepath, boolean append) {
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(filepath));
            outputStream.writeObject(so);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public static void writeObject(Object o, String filepath) {
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(filepath));
            outputStream.writeObject(o);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchObject readSearchObjectfromFile(String filePath) {
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new FileInputStream(filePath));
            Object obj = null;
            while ((obj = inputStream.readObject()) != null) {
                if (!(obj instanceof SearchObject)) continue;
                SearchObject searchObject = (SearchObject)obj;
                return searchObject;
            }
        }
        catch (EOFException ex) {
            System.out.println("End of file reached.");
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)ex);
        }
        catch (FileNotFoundException ex) {
            log.error((Object)ex);
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFromTextFile(String filePath) {
        StringBuilder contents = new StringBuilder();
        File aFile = new File(filePath);
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            log.error((Object)("fileName: " + filePath), (Throwable)ex);
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLinesFromTextFile(String filePath) {
        ArrayList<String> lines = new ArrayList<String>();
        File aFile = new File(filePath);
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    lines.add(line);
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectfromFile(String filePath) {
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new FileInputStream(filePath));
            Object obj = null;
            obj = inputStream.readObject();
            if (obj != null) {
                Object object = obj;
                return object;
            }
        }
        catch (EOFException ex) {
            System.out.println("End of file reached.");
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)ex);
        }
        catch (FileNotFoundException ex) {
            log.error((Object)ex);
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
        }
        return null;
    }

    public static byte[] getBytes(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        bos.close();
        byte[] data = bos.toByteArray();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents() {
        StringBuilder contents = new StringBuilder();
        File aFile = new File("//home//gado//Desktop//source.txt");
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
        return contents.toString();
    }

    public static void writeToTextFile(ArrayList<String> list, String filePath, boolean append) throws Exception {
        FileWriter outFile = null;
        Object fr = null;
        Iterator<String> it = list.iterator();
        if (!append) {
            outFile = new FileWriter(filePath);
            PrintWriter out = new PrintWriter(outFile);
            while (it.hasNext()) {
                out.println(it.next());
            }
            outFile.close();
        } else {
            int tmp = 0;
            while (it.hasNext()) {
                if (tmp == 0) {
                    FileWork.appendtofile("\n" + it.next(), filePath);
                } else {
                    FileWork.appendtofile(it.next(), filePath);
                }
                ++tmp;
            }
        }
    }

    private static void appendtofile(String data, String filePath) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filePath, true));
            out.write(data + "\n");
            out.close();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public static boolean fileOrDirectoryExists(String path) {
        File file = new File(path);
        boolean exists = file.exists();
        return exists;
    }

    public static ArrayList<String> getFileNamesInFolder(String dirPath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File folder = new File(dirPath);
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (listOfFiles[i].isFile()) {
                fileNames.add(listOfFiles[i].getName());
                continue;
            }
            if (!listOfFiles[i].isDirectory()) continue;
        }
        return fileNames;
    }

    public static ArrayList<String> getFilePathsInFolder(String dirPath) {
        ArrayList<String> filePaths = new ArrayList<String>();
        File folder = new File(dirPath);
        File[] listOfFiles = folder.listFiles();
        int size = 0;
        if (listOfFiles != null) {
            size = listOfFiles.length;
        }
        for (int i = 0; i < size; ++i) {
            if (listOfFiles[i].isFile()) {
                filePaths.add(listOfFiles[i].getAbsolutePath());
                continue;
            }
            if (!listOfFiles[i].isDirectory()) continue;
        }
        return filePaths;
    }

    public static int getFileNumInFolder(String dirPath) {
        int num = 0;
        try {
            num = FileWork.getFileNamesInFolder(dirPath).size();
        }
        catch (Exception e) {
            num = 0;
        }
        return num;
    }

    public static void delete(String fileName) {
        String[] files;
        File f = new File(fileName);
        if (!f.exists()) {
            throw new IllegalArgumentException("Delete: no such file or directory: " + fileName);
        }
        if (!f.canWrite()) {
            throw new IllegalArgumentException("Delete: write protected: " + fileName);
        }
        if (f.isDirectory() && (files = f.list()).length > 0) {
            throw new IllegalArgumentException("Delete: directory not empty: " + fileName);
        }
        boolean success = f.delete();
        if (!success) {
            throw new IllegalArgumentException("Delete: deletion failed");
        }
    }

    public static boolean createDir(String strDirectoy) {
        boolean success = false;
        try {
            success = !strDirectoy.contains("\\") && !strDirectoy.contains("/") ? new File(strDirectoy).mkdir() : new File(strDirectoy).mkdirs();
        }
        catch (Exception e) {
            log.error((Object)"No way to create dir", (Throwable)e);
        }
        return success;
    }
}

