/*
 * Decompiled with CFR 0.152.
 */
package CM.GUI;

import CM.GUI.BrowserControl;
import CM.GUI.Link;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class URLRenderer
extends DefaultTableCellRenderer
implements MouseListener,
MouseMotionListener {
    private int row = -1;
    private int col = -1;
    JTable table;

    URLRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        this.table = table;
        if (!table.isEditing() && this.row == row && this.col == column) {
            Link link = (Link)value;
            this.setText(link.getName());
            this.setForeground(Color.ORANGE);
        } else if (hasFocus) {
            Link link = (Link)value;
            this.setText(link.getName());
            this.setForeground(Color.ORANGE);
        } else {
            Link link = (Link)value;
            this.setText(link.getName());
            this.setForeground(Color.BLUE);
        }
        return this;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        this.row = table.rowAtPoint(pt);
        this.col = table.columnAtPoint(pt);
        if (this.col == 1 || this.col == 3) {
            table.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            table.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.row < 0 || this.col < 0) {
            this.row = -1;
            this.col = -1;
        }
        table.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        this.row = -1;
        this.col = -1;
        table.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        int crow = table.rowAtPoint(pt);
        int ccol = table.columnAtPoint(pt);
        if (table.getColumnClass(ccol).equals(Link.class)) {
            System.out.println(table.getValueAt(crow, ccol));
            Link link = (Link)table.getValueAt(crow, ccol);
            BrowserControl.displayURL(link.getURL().toString());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

