/*
 * Decompiled with CFR 0.152.
 */
package CM.Tools;

import CM.Configuration.Configuration;
import CM.GUI.CvObject;
import CM.GUI.SoAndFileName;
import CM.Tools.FileWork;
import CM.core.Content;
import CM.core.SearchObject;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XML_reader {
    Logger log = Logger.getLogger(XML_reader.class);
    Configuration config = Configuration.getInstance();
    private Document dom;
    private DocumentBuilder db;

    public XML_reader(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                this.db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                this.log.error((Object)ex);
            }
            this.dom = this.db.parse(file);
        }
        catch (SAXException ex) {
            this.log.error((Object)ex);
        }
        catch (IOException ex) {
            this.log.error((Object)ex);
        }
    }

    public CvObject runRead() {
        CvObject cvObject = new CvObject();
        cvObject.setName(this.parseDocument("cv_name").get(0).toString());
        ArrayList paths = this.parseDocument("cv_snapshot");
        ArrayList<SoAndFileName> sofnList = new ArrayList<SoAndFileName>();
        for (int i = 0; i < paths.size(); ++i) {
            sofnList.add(new SoAndFileName(FileWork.readSearchObjectfromFile((String)paths.get(i)), (String)paths.get(i)));
        }
        cvObject.setSnapshots(sofnList);
        try {
            cvObject.setCreatedAt(this.config.getDf().parse(this.parseDocument("cv_date").get(0).toString()));
        }
        catch (ParseException e) {
            this.log.error((Object)"No way to retrieve date from cv descriptor", (Throwable)e);
        }
        return cvObject;
    }

    @Deprecated
    public SearchObject runread() throws Exception {
        SearchObject searchObject = new SearchObject();
        ArrayList inclNameList = new ArrayList();
        ArrayList exclNameList = new ArrayList();
        ArrayList areaList = new ArrayList();
        ArrayList<Content> contentList = new ArrayList<Content>();
        inclNameList = this.parseDocument("incl_name");
        String[] inclNameListArray = new String[inclNameList.size()];
        inclNameList.toArray(inclNameListArray);
        exclNameList = this.parseDocument("excl_name");
        String[] exclNameListArray = new String[exclNameList.size()];
        exclNameList.toArray(exclNameListArray);
        areaList = this.parseDocument("area");
        String[] areaListArray = new String[areaList.size()];
        areaList.toArray(areaListArray);
        searchObject.setInclNames(inclNameListArray);
        searchObject.setExclNames(exclNameListArray);
        searchObject.setAreas(areaListArray);
        searchObject.setSearchDate(this.config.getDf().parse(this.parseDocument("search_date").get(0).toString()));
        searchObject.setYearFrom(new Integer(this.parseDocument("year_from").get(0).toString()));
        searchObject.setYearTo(new Integer(this.parseDocument("year_to").get(0).toString()));
        NodeList nodeLst = this.dom.getElementsByTagName("content");
        for (int s = 0; s < nodeLst.getLength(); ++s) {
            Content content = new Content();
            Node fstNode = nodeLst.item(s);
            if (fstNode.getNodeType() == 1) {
                NodeList is_mineElmntLst;
                Element is_mineElmnt;
                NodeList is_mine;
                NodeList yearElmntLst;
                Element yearElmnt;
                NodeList year;
                NodeList mediaElmntLst;
                Element mediaElmnt;
                NodeList media;
                NodeList publisherElmntLst;
                Element publisherElmnt;
                NodeList publisher;
                NodeList cit_num_selfElmntLst;
                Element cit_num_selfElmnt;
                NodeList cit_num_self;
                NodeList cit_numElmntLst;
                Element cit_numElmnt;
                NodeList cit_num;
                NodeList cit_linkElmntLst;
                Element cit_linkElmnt;
                NodeList cit_link;
                NodeList linkElmntLst;
                Element linkElmnt;
                NodeList link;
                NodeList titleElmntLst;
                Element titleElmnt;
                NodeList title;
                NodeList rankElmntLst;
                Element rankElmnt;
                NodeList rank;
                Element fstElmnt = (Element)fstNode;
                NodeList cntIdElmntLst = fstElmnt.getElementsByTagName("content_id");
                Element cntIdElmnt = (Element)cntIdElmntLst.item(0);
                NodeList contentId = cntIdElmnt.getChildNodes();
                if (contentId.item(0) != null) {
                    content.setContentId(contentId.item(0).getNodeValue());
                }
                if ((rank = (rankElmnt = (Element)(rankElmntLst = fstElmnt.getElementsByTagName("rank")).item(0)).getChildNodes()).item(0) != null) {
                    content.setRank(new Integer(rank.item(0).getNodeValue()));
                }
                if ((title = (titleElmnt = (Element)(titleElmntLst = fstElmnt.getElementsByTagName("title")).item(0)).getChildNodes()).item(0) != null) {
                    content.setTitle(title.item(0).getNodeValue());
                }
                if ((link = (linkElmnt = (Element)(linkElmntLst = fstElmnt.getElementsByTagName("link")).item(0)).getChildNodes()).item(0) != null) {
                    content.setLink(link.item(0).getNodeValue());
                }
                if ((cit_link = (cit_linkElmnt = (Element)(cit_linkElmntLst = fstElmnt.getElementsByTagName("cit_link")).item(0)).getChildNodes()).item(0) != null) {
                    content.setCitLink(cit_link.item(0).getNodeValue());
                }
                if ((cit_num = (cit_numElmnt = (Element)(cit_numElmntLst = fstElmnt.getElementsByTagName("cit_num")).item(0)).getChildNodes()).item(0) != null) {
                    content.setCitNum(new Integer(cit_num.item(0).getNodeValue()));
                }
                if ((cit_num_self = (cit_num_selfElmnt = (Element)(cit_num_selfElmntLst = fstElmnt.getElementsByTagName("cit_num_self")).item(0)).getChildNodes()).item(0) != null) {
                    content.setSelfCitNum(new Integer(cit_num_self.item(0).getNodeValue()));
                }
                if ((publisher = (publisherElmnt = (Element)(publisherElmntLst = fstElmnt.getElementsByTagName("publisher")).item(0)).getChildNodes()).item(0) != null) {
                    content.setPublisher(publisher.item(0).getNodeValue());
                }
                if ((media = (mediaElmnt = (Element)(mediaElmntLst = fstElmnt.getElementsByTagName("media")).item(0)).getChildNodes()).item(0) != null) {
                    content.setMedia(media.item(0).getNodeValue());
                }
                if ((year = (yearElmnt = (Element)(yearElmntLst = fstElmnt.getElementsByTagName("year")).item(0)).getChildNodes()).item(0) != null) {
                    content.setYear(new Integer(year.item(0).getNodeValue()));
                }
                if ((is_mine = (is_mineElmnt = (Element)(is_mineElmntLst = fstElmnt.getElementsByTagName("is_mine")).item(0)).getChildNodes()).item(0) != null) {
                    content.setMine(new Boolean(is_mine.item(0).getNodeValue()));
                }
                NodeList authorElmntLst = fstElmnt.getElementsByTagName("author");
                ArrayList<String> authors = new ArrayList<String>();
                for (int j = 0; j < authorElmntLst.getLength(); ++j) {
                    Element authorElmnt = (Element)authorElmntLst.item(j);
                    NodeList author = authorElmnt.getChildNodes();
                    if (author.item(0) == null) continue;
                    authors.add(author.item(0).getNodeValue());
                }
                content.setAuthors(authors);
            }
            contentList.add(content);
        }
        searchObject.setSearchResults(contentList);
        return searchObject;
    }

    private void parseXmlFile(String xml) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(new InputSource(new StringReader(xml)));
        }
        catch (ParserConfigurationException pce) {
        }
        catch (SAXException se) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ArrayList parseDocument(String tagName) {
        ArrayList<String> returnArray = new ArrayList<String>();
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                if (el.getChildNodes().getLength() > 1) {
                    for (int j = 0; j < el.getChildNodes().getLength(); ++j) {
                        if (el.getChildNodes().item(j).getNodeName().contains("#")) continue;
                        returnArray.add(el.getChildNodes().item(j).getNodeName());
                        returnArray.add(el.getChildNodes().item(j).getTextContent());
                    }
                    continue;
                }
                returnArray.add(el.getTextContent());
            }
        }
        return returnArray;
    }

    private String getTextValue(Element ele, String tagName) {
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    private int getIntValue(Element ele, String tagName) {
        int value = 0;
        try {
            value = Integer.parseInt(this.getTextValue(ele, tagName));
        }
        catch (Exception e) {
            this.log.error((Object)"No way to convert String to int", (Throwable)e);
        }
        return value;
    }
}

