/*
 * Decompiled with CFR 0.152.
 */
package CM.Tools;

import CM.Configuration.Configuration;
import CM.GUI.CvObject;
import CM.core.Content;
import CM.core.SearchObject;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XML_creator {
    DocumentBuilder db;
    Transformer transformer;
    Configuration config = Configuration.getInstance();
    Logger log = Logger.getLogger(XML_creator.class);

    public String createCVdescriptor(CvObject myCV) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)e);
        }
        Document document = this.db.newDocument();
        Element cv = document.createElement("cv");
        document.appendChild(cv);
        Element cvName = document.createElement("cv_name");
        cvName.appendChild(document.createTextNode(myCV.getName()));
        cv.appendChild(cvName);
        Element cvDate = document.createElement("cv_date");
        cvDate.appendChild(document.createTextNode(this.config.getDf().format(myCV.getCreatedAt())));
        cv.appendChild(cvDate);
        Element cvSnapshots = document.createElement("cv_snapshots");
        cv.appendChild(cvSnapshots);
        for (int i = 0; i < myCV.getSnapshots().size(); ++i) {
            Element cvSnapshot = document.createElement("cv_snapshot");
            cvSnapshot.appendChild(document.createTextNode(myCV.getSnapshots().get(i).getFilePath()));
            cvSnapshots.appendChild(cvSnapshot);
        }
        try {
            this.transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            this.log.error((Object)e);
        }
        this.transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(new StringWriter());
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            this.log.error((Object)e);
        }
        String xmlString = result.getWriter().toString();
        return xmlString;
    }

    @Deprecated
    public String create(SearchObject object) {
        int i;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)e);
        }
        Document document = this.db.newDocument();
        Element search = document.createElement("search");
        document.appendChild(search);
        Element searchParameters = document.createElement("search_parameters");
        search.appendChild(searchParameters);
        Element search_date = document.createElement("search_date");
        search_date.appendChild(document.createTextNode(object.getSearchDate().toString()));
        for (i = 0; i < object.getInclNames().length; ++i) {
            Element inclName = document.createElement("incl_name");
            inclName.appendChild(document.createTextNode(object.getInclNames()[i]));
            searchParameters.appendChild(inclName);
        }
        for (i = 0; i < object.getExclNames().length; ++i) {
            Element exclName = document.createElement("excl_name");
            exclName.appendChild(document.createTextNode(object.getExclNames()[i]));
            searchParameters.appendChild(exclName);
        }
        Element yearFrom = document.createElement("year_from");
        yearFrom.appendChild(document.createTextNode(new Integer(object.getYearFrom()).toString()));
        Element yearTo = document.createElement("year_to");
        yearTo.appendChild(document.createTextNode(new Integer(object.getYearTo()).toString()));
        for (int i2 = 0; i2 < object.getAreas().length; ++i2) {
            Element area = document.createElement("area");
            area.appendChild(document.createTextNode(object.getAreas()[i2]));
            searchParameters.appendChild(area);
        }
        searchParameters.appendChild(search_date);
        searchParameters.appendChild(yearFrom);
        searchParameters.appendChild(yearTo);
        Element searchResults = document.createElement("search_results");
        search.appendChild(searchResults);
        Content tmpContent = new Content();
        if (object.getSearchResults() != null) {
            for (int i3 = 0; i3 < object.getSearchResults().size(); ++i3) {
                Element content = document.createElement("content");
                tmpContent = object.getSearchResults().get(i3);
                Element contentId = document.createElement("content_id");
                String tmpContentId = tmpContent.getContentId();
                if (tmpContentId == null || tmpContentId.equals("")) {
                    tmpContentId = "NA";
                }
                contentId.appendChild(document.createTextNode(tmpContentId));
                content.appendChild(contentId);
                Element rank = document.createElement("rank");
                rank.appendChild(document.createTextNode(Integer.toString(tmpContent.getRank())));
                content.appendChild(rank);
                Element title = document.createElement("title");
                title.appendChild(document.createTextNode(tmpContent.getTitle()));
                content.appendChild(title);
                Element link = document.createElement("link");
                link.appendChild(document.createTextNode(tmpContent.getLink()));
                content.appendChild(link);
                Element citLink = document.createElement("cit_link");
                citLink.appendChild(document.createTextNode(tmpContent.getCitLink()));
                content.appendChild(citLink);
                Element citNum = document.createElement("cit_num");
                citNum.appendChild(document.createTextNode(Integer.toString(tmpContent.getCitNum())));
                content.appendChild(citNum);
                Element citNumSelf = document.createElement("cit_num_self");
                citNumSelf.appendChild(document.createTextNode(Integer.toString(tmpContent.getSelfCitNum())));
                content.appendChild(citNumSelf);
                Element publisher = document.createElement("publisher");
                publisher.appendChild(document.createTextNode(tmpContent.getPublisher()));
                content.appendChild(publisher);
                Element media = document.createElement("media");
                String tmpMedia = tmpContent.getMedia();
                if (tmpMedia == null || tmpMedia.equals("")) {
                    tmpMedia = "NA";
                }
                media.appendChild(document.createTextNode(tmpMedia));
                content.appendChild(media);
                Element year = document.createElement("year");
                year.appendChild(document.createTextNode(Integer.toString(tmpContent.getYear())));
                content.appendChild(year);
                Element isMine = document.createElement("is_mine");
                isMine.appendChild(document.createTextNode(new Boolean(tmpContent.isMine()).toString()));
                content.appendChild(isMine);
                if (tmpContent.getAuthors() != null) {
                    for (int j = 0; j < tmpContent.getAuthors().size(); ++j) {
                        Element author = document.createElement("author");
                        author.appendChild(document.createTextNode(tmpContent.getAuthors().get(j)));
                        content.appendChild(author);
                    }
                }
                searchResults.appendChild(content);
            }
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            this.transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        this.transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(new StringWriter());
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        String xmlString = result.getWriter().toString();
        return xmlString;
    }
}

