/*
 * Decompiled with CFR 0.152.
 */
package CM.Tools;

import CM.Tools.Settings;
import CM.core.FileWork;
import CM.data.CM_data;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Configuration {
    private Logger log = Logger.getLogger(Configuration.class);
    private static Configuration instance;
    private SimpleDateFormat df = new SimpleDateFormat("yyyy MM dd HH:mm:ss");
    Settings settings;
    private String cvDescriptorName = "cvDescriptor.xml";
    private int delay;
    private int delayRandMin;
    private int delayRandMax;
    private int waitDelayRandMin;
    private int waitDelayRandMax;
    private int minPageNum;
    private int maxPageNum;
    private int maxChachedFileNum;
    private boolean isCacheEnabled;
    private boolean isCacheEnabledIndicator;
    private boolean updateSession = false;
    String noChacheBefore;
    CM_data cmData;
    NumberFormat nf = NumberFormat.getInstance(Locale.US);

    private Configuration() {
        this.settings = Settings.getInstance();
        try {
            this.settings.load("settings.properties", null);
        }
        catch (IOException ex) {
            this.log.error((Object)"no way to load settings.properties", (Throwable)ex);
        }
        try {
            this.delay = new Integer(Settings.get("delay"));
            this.delayRandMin = new Integer(Settings.get("delayRandMin"));
            this.delayRandMax = new Integer(Settings.get("delayRandMax"));
            this.waitDelayRandMin = new Integer(Settings.get("waitDelayRandMin"));
            this.waitDelayRandMax = new Integer(Settings.get("waitDelayRandMax"));
            this.minPageNum = new Integer(Settings.get("minPageNum"));
            this.maxPageNum = new Integer(Settings.get("maxPageNum"));
            this.maxChachedFileNum = new Integer(Settings.get("maxChachedFileNum"));
            this.noChacheBefore = Settings.get("noChacheBefore");
            this.isCacheEnabledIndicator = this.isCacheEnabled = new Boolean(Settings.get("isCacheEnabled")).booleanValue();
        }
        catch (NumberFormatException e) {
            this.log.error((Object)"can not load some parameter from the property file", (Throwable)e);
        }
    }

    public String getCvDescriptorName() {
        return this.cvDescriptorName;
    }

    public SimpleDateFormat getDf() {
        return this.df;
    }

    public boolean isUpdateSession() {
        return this.updateSession;
    }

    public void setUpdateSession(boolean updateSession) {
        if (updateSession) {
            if (this.isCacheEnabledIndicator) {
                this.isCacheEnabled = false;
            }
        } else {
            this.isCacheEnabled = this.isCacheEnabledIndicator;
        }
        this.updateSession = updateSession;
    }

    public boolean isIsCacheEnabled() {
        return this.isCacheEnabled;
    }

    public void setIsCacheEnabled(boolean isCacheEnabled) {
        this.isCacheEnabled = isCacheEnabled;
    }

    public Date getNoChacheBefore() {
        Date date = null;
        try {
            date = this.df.parse(this.noChacheBefore);
        }
        catch (ParseException e) {
            this.log.error((Object)"Erroro occured during reading the \"dontChacheBefore\" parameter from the parameter-file! ", (Throwable)e);
        }
        return date;
    }

    public void setNoChacheBefore(String noChacheBefore) {
        this.noChacheBefore = noChacheBefore;
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getDelayRandMax() {
        return this.delayRandMax;
    }

    public int getDelayRandMin() {
        return this.delayRandMin;
    }

    public int getMaxPageNum() {
        return this.maxPageNum;
    }

    public int getMinPageNum() {
        return this.minPageNum;
    }

    public int getWaitDelayRandMax() {
        return this.waitDelayRandMax;
    }

    public int getWaitDelayRandMin() {
        return this.waitDelayRandMin;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setDelayRandMax(int delayRandMax) {
        this.delayRandMax = delayRandMax;
    }

    public void setDelayRandMin(int delayRandMin) {
        this.delayRandMin = delayRandMin;
    }

    public void setMaxPageNum(int maxPageNum) {
        this.maxPageNum = maxPageNum;
    }

    public void setMinPageNum(int minPageNum) {
        this.minPageNum = minPageNum;
    }

    public void setWaitDelayRandMax(int waitDelayRandMax) {
        this.waitDelayRandMax = waitDelayRandMax;
    }

    public void setWaitDelayRandMin(int waitDelayRandMin) {
        this.waitDelayRandMin = waitDelayRandMin;
    }

    public int getMaxChachedFileNum() {
        return this.maxChachedFileNum;
    }

    public void setMaxChachedFileNum(int maxChachedFileNum) {
        this.maxChachedFileNum = maxChachedFileNum;
    }

    public void save(Properties prop) throws IOException {
        this.delay = new Integer(prop.getProperty("delay"));
        this.delayRandMin = new Integer(prop.getProperty("delayRandMin"));
        this.delayRandMax = new Integer(prop.getProperty("delayRandMax"));
        this.waitDelayRandMin = new Integer(prop.getProperty("waitDelayRandMin"));
        this.waitDelayRandMax = new Integer(prop.getProperty("waitDelayRandMax"));
        this.minPageNum = new Integer(prop.getProperty("minPageNum"));
        this.maxPageNum = new Integer(prop.getProperty("maxPageNum"));
        this.isCacheEnabledIndicator = this.isCacheEnabled = new Boolean(prop.getProperty("isCacheEnabled")).booleanValue();
        Settings.getInstance().save(prop);
    }

    public int startUpTask() {
        int acrtionCode = -1;
        this.deleteOldChache();
        Object data = FileWork.readObjectfromFile("data/CM_data.dat");
        if (data == null) {
            this.log.info((Object)"data/CM_data.dat is missing. Fist startup. Let's create a new.");
            this.cmData = new CM_data();
            this.cmData.setTotalStartUps(1);
            FileWork.writeObject(this.cmData, "data/CM_data.dat");
            acrtionCode = 0;
        } else if (data instanceof CM_data) {
            this.cmData = (CM_data)data;
            this.cmData.increaseTotalStartUps();
            if (this.cmData.isSyncronization()) {
                this.cmData.countDown();
                if (this.cmData.getSyncCountDown() == 0) {
                    this.cmData.setSyncCountDown(5);
                    acrtionCode = 1;
                }
            }
            FileWork.writeObject(this.cmData, "data/CM_data.dat");
        } else {
            this.log.error((Object)"CM_data.dat compatibility issue.");
            FileWork.writeObject(this.cmData, "data/_CM_data_broken.dat");
            this.cmData = new CM_data();
            this.cmData.setTotalStartUps(1);
            FileWork.writeObject(this.cmData, "data/CM_data.dat");
            acrtionCode = 0;
        }
        return acrtionCode;
    }

    private void deleteOldChache() {
        Iterator<String> it = FileWork.getFilePathsInFolder("cache").iterator();
        String tmpFileName = "";
        while (it.hasNext()) {
            tmpFileName = it.next();
            try {
                if (!FileWork.readSearchObjectfromFile(tmpFileName).getSearchDate().before(this.df.parse(this.noChacheBefore))) continue;
                FileWork.delete(tmpFileName);
            }
            catch (ParseException e) {
                this.log.error((Object)"No way to parse nocacheBefore string", (Throwable)e);
            }
        }
    }

    public NumberFormat getNumberFormat() {
        return this.nf;
    }

    public CM_data getCmData() {
        return this.cmData;
    }

    public void setCmData(CM_data cmData) {
        this.cmData = cmData;
    }

    public void writeCMDataToDisk() {
        FileWork.writeObject(this.cmData, "data/CM_data.dat");
    }

    public void writeCMDataToDisk(CM_data data) {
        FileWork.writeObject(data, "data/CM_data.dat");
    }
}

