/*
 * Decompiled with CFR 0.152.
 */
package CM.GUI;

import CM.GUI.CvObject;
import CM.core.SearchObject;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.ListModel;

public class SnapshotList
extends JList {
    public SnapshotList(CvObject soo) {
        this.setListData(this.createLinks(soo));
        this.setToolTipText("");
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int index = this.locationToIndex(e.getPoint());
        if (index > -1) {
            ListModel lm = this.getModel();
            ToolTipLink link = (ToolTipLink)lm.getElementAt(index);
            return link.getToolTipText();
        }
        return null;
    }

    private Object[] createLinks(CvObject soo) {
        Object[] links = new ToolTipLink[soo.getSnapshots().size()];
        for (int i = 0; i < soo.getSnapshots().size(); ++i) {
            links[i] = new ToolTipLink(soo.getSnapshots().get(i).getFileName(), this.getTipfromSo(soo.getSnapshots().get(i).getSo()));
        }
        return links;
    }

    private String getTipfromSo(SearchObject so) {
        String toolTip = "<html>";
        if (so != null) {
            int i;
            toolTip = toolTip + "<b>Date:</b><br>";
            toolTip = toolTip + so.getSearchDate().toString() + "<br>";
            toolTip = toolTip + "<b>Citnum:</b><br>";
            toolTip = toolTip + so.getCitnum() + "<br>";
            toolTip = toolTip + "<b>Self-citation tracking:</b><br>";
            if (so.isIsSelfcitationFiltered()) {
                toolTip = toolTip + "Yes<br>";
                toolTip = toolTip + "<b>Self citations:</b><br>";
                toolTip = toolTip + so.getSelfCitnum() + "<br>";
            } else {
                toolTip = toolTip + "No<br>";
            }
            toolTip = toolTip + "<b>Names included:</b><br>";
            for (i = 0; i < so.getInclNames().length; ++i) {
                toolTip = i < so.getInclNames().length - 1 ? toolTip + so.getInclNames()[i] + " | " : toolTip + so.getInclNames()[i] + "<br>";
            }
            toolTip = toolTip + "<b>Names excluded:</b><br>";
            for (i = 0; i < so.getExclNames().length; ++i) {
                toolTip = i < so.getExclNames().length - 1 ? toolTip + so.getExclNames()[i] + " | " : toolTip + so.getExclNames()[i] + "<br>";
            }
            toolTip = toolTip + "<b>Areas:</b><br>";
            for (i = 0; i < so.getAreas().length; ++i) {
                toolTip = i < so.getAreas().length - 1 ? toolTip + so.getAreas()[i] + " | " : toolTip + so.getAreas()[i] + "<br>";
            }
            toolTip = toolTip + "<b>Betwen years:</b><br>";
            toolTip = toolTip + so.getYearFrom() + " - " + so.getYearTo() + "<br>";
        }
        return toolTip;
    }

    public class ToolTipLink {
        private String name;
        private String tipText;

        public ToolTipLink(String name, String tipText) {
            this.name = name;
            this.tipText = tipText;
        }

        public String getToolTipText() {
            return this.tipText;
        }

        public String toString() {
            return this.name;
        }
    }
}

