/*
 * Decompiled with CFR 0.152.
 */
package CM.GUI;

import CM.GUI.Link;
import CM.GUI.cmGUIView;
import CM.core.Content;
import CM.core.ExtraColumnElement;
import CM.core.SearchObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class MyTableModel
extends AbstractTableModel {
    SearchObject so = new SearchObject();
    String key = "";
    URL failureURL;
    protected String[] columnNames;
    private Logger log = Logger.getLogger(MyTableModel.class);
    boolean DEBUG = true;

    public MyTableModel(String Key2) {
        this.key = Key2;
        this.so = cmGUIView.openContents.get(Key2);
        try {
            this.failureURL = new URL("http://scholar.google.com");
        }
        catch (MalformedURLException ex) {
            this.log.error((Object)ex);
        }
        this.columnNames = this.so == null ? new String[]{"Rank", "Title", "Authors", "Cites", "Self-citations", "Publisher", "Media", "Year", "It's mine"} : (this.so.isIsCV() ? new String[]{"Rank", "Title", "Authors", "Cites", "Self-citations", "Publisher", "Media", "Year"} : new String[]{"Rank", "Title", "Authors", "Cites", "Self-citations", "Publisher", "Media", "Year", "It's mine"});
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String getColumnName(int col) {
        String name = "";
        if (!this.so.isIsCV()) {
            if (col < 9 && col > -1) {
                name = this.columnNames[col].toString();
            } else if (col > -1) {
                name = this.so.getSearchResults().get(0).getExtraColumnElementArray().get(col - 9).getName();
            }
        } else if (col < 8 && col > -1) {
            name = this.columnNames[col].toString();
        }
        return name;
    }

    @Override
    public int getColumnCount() {
        if (this.so.getSearchResults().size() >= 1) {
            if (!this.so.isIsCV()) {
                return this.columnNames.length + this.so.getSearchResults().get(0).getExtraColumnElementArray().size();
            }
            return this.columnNames.length;
        }
        return 0;
    }

    @Override
    public int getRowCount() {
        return this.so.getSearchResults().size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object y = null;
        if (row > -1) {
            ArrayList<String> authors = this.so.getSearchResults().get(row).getAuthors();
            String authorString = "";
            for (int i = 0; i < authors.size(); ++i) {
                authorString = i < authors.size() - 1 ? authorString + authors.get(i) + ";" : authorString + authors.get(i);
            }
            switch (col) {
                case 0: {
                    y = this.so.getSearchResults().get(row).getRank();
                    break;
                }
                case 1: {
                    try {
                        y = new Link(this.so.getSearchResults().get(row).getTitle(), new URL(this.so.getSearchResults().get(row).getLink()));
                    }
                    catch (Exception e) {
                        y = new Link(this.so.getSearchResults().get(row).getTitle(), this.failureURL);
                    }
                    break;
                }
                case 2: {
                    y = authorString;
                    break;
                }
                case 3: {
                    try {
                        URL url = new URL("http://scholar.google.com/scholar?start=0&hl=en&num=100&as_sdt=2000&cites=" + this.so.getSearchResults().get(row).getCitLink());
                        Link link = new Link(this.so.getSearchResults().get(row).getCitNum() + "", url);
                        y = link;
                    }
                    catch (Exception e) {
                        y = new Link(this.so.getSearchResults().get(row).getCitNum() + "", this.failureURL);
                    }
                    break;
                }
                case 4: {
                    y = this.so.getSearchResults().get(row).getSelfCitNum();
                    break;
                }
                case 5: {
                    y = this.so.getSearchResults().get(row).getPublisher();
                    break;
                }
                case 6: {
                    y = this.so.getSearchResults().get(row).getMedia();
                    break;
                }
                case 7: {
                    y = this.so.getSearchResults().get(row).getYear();
                    break;
                }
                case 8: {
                    y = this.so.getSearchResults().get(row).isMine();
                }
            }
            if (!this.so.isIsCV() && col > 8) {
                y = this.so.getSearchResults().get(row).getExtraColumnElementArray().get(col - 9).getType().equals((Object)ExtraColumnElement.Type.BOOLEAN) ? Boolean.valueOf(this.so.getSearchResults().get(row).getExtraColumnElementArray().get(col - 9).isIsTrue()) : this.so.getSearchResults().get(row).getExtraColumnElementArray().get(col - 9).getContent();
            }
        }
        return y;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.DEBUG) {
            System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
        }
        switch (col) {
            case 8: {
                this.so.getSearchResults().get(row).setMine(new Boolean(value.toString()));
            }
        }
        if (col > 8) {
            if (this.so.getSearchResults().get(row).getExtraColumnElementArray().get(col - 9).getType().equals((Object)ExtraColumnElement.Type.BOOLEAN)) {
                this.so.getSearchResults().get(row).getExtraColumnElementArray().get(col - 9).setIsTrue(new Boolean(value.toString()));
            } else {
                System.err.println("mika");
                this.so.getSearchResults().get(row).getExtraColumnElementArray().get(col - 9).setContent(value.toString());
            }
        }
        this.fireTableCellUpdated(row, col);
        this.so.setIsSaved(false);
        cmGUIView.openContents.put(this.key, this.so);
    }

    protected int getCitnum() {
        int citNum = 0;
        for (Content tmp : this.so.getSearchResults()) {
            if (tmp.getCitNum() <= 0 || !tmp.isMine()) continue;
            citNum += tmp.getCitNum();
        }
        return citNum;
    }

    protected int getSelfCitnum() {
        int selfCitNum = 0;
        for (Content tmp : this.so.getSearchResults()) {
            if (tmp.getSelfCitNum() <= 0 || !tmp.isMine()) continue;
            selfCitNum += tmp.getSelfCitNum();
        }
        return selfCitNum;
    }

    public double getAVGall() {
        return (double)this.getCitnum() / ((double)this.getRowCount() + 0.0);
    }

    public double getAVGallNoSelf() {
        return (double)(this.getCitnum() - this.getSelfCitnum()) / ((double)this.getRowCount() + 0.0);
    }

    public int getHindex() {
        int counter = 0;
        ArrayList<Integer> citNumList = new ArrayList<Integer>();
        for (Content content : this.so.getSearchResults()) {
            if (!content.isMine()) continue;
            citNumList.add(content.getCitNum());
        }
        Collections.sort(citNumList);
        for (int i = citNumList.size() - 1; i > 0; --i) {
            if (++counter <= (Integer)citNumList.get(i)) continue;
            return counter - 1;
        }
        return 0;
    }

    public int getHSindex() {
        int counter = 0;
        ArrayList<Integer> citNumList = new ArrayList<Integer>();
        for (Content content : this.so.getSearchResults()) {
            if (!content.isMine()) continue;
            citNumList.add(content.getCitNum() - content.getSelfCitNum());
        }
        Collections.sort(citNumList);
        for (int i = citNumList.size() - 1; i > 0; --i) {
            if (++counter <= (Integer)citNumList.get(i)) continue;
            return counter - 1;
        }
        return 0;
    }

    public double getMedianS() {
        ArrayList<Integer> citNumList = new ArrayList<Integer>();
        for (Content content : this.so.getSearchResults()) {
            if (!content.isMine()) continue;
            citNumList.add(content.getCitNum() - content.getSelfCitNum());
        }
        if (citNumList.size() > 2) {
            Collections.sort(citNumList);
            if (citNumList.size() % 2 == 1) {
                return ((Integer)citNumList.get(citNumList.size() / 2 + 1)).intValue();
            }
            return (double)((Integer)citNumList.get(citNumList.size() / 2) + (Integer)citNumList.get(citNumList.size() / 2 + 1)) / 2.0;
        }
        this.log.info((Object)"Not enough papers to calculate medianS");
        return 0.0;
    }

    public double getMedian() {
        ArrayList<Integer> citNumList = new ArrayList<Integer>();
        for (Content content : this.so.getSearchResults()) {
            if (!content.isMine()) continue;
            citNumList.add(content.getCitNum());
        }
        if (citNumList.size() > 2) {
            Collections.sort(citNumList);
            if (citNumList.size() % 2 == 1) {
                return ((Integer)citNumList.get(citNumList.size() / 2 + 1)).intValue();
            }
            return (double)((Integer)citNumList.get(citNumList.size() / 2) + (Integer)citNumList.get(citNumList.size() / 2 + 1)) / 2.0;
        }
        this.log.info((Object)"Not enough papers to calculate median");
        return 0.0;
    }

    public double getAindex() {
        return (double)this.getCitnum() / ((double)(this.getHindex() * this.getHSindex()) + 0.0);
    }

    public double getGindex() {
        ArrayList<Integer> citNumList = new ArrayList<Integer>();
        ArrayList gTmpArray = new ArrayList();
        for (Content content : this.so.getSearchResults()) {
            if (!content.isMine()) continue;
            citNumList.add(content.getCitNum());
        }
        Collections.sort(citNumList);
        int tmp = citNumList.size() - 1;
        int counter = 1;
        for (int i = citNumList.size() - 1; i > 1; --i) {
            if (counter * counter < tmp) {
                tmp += ((Integer)citNumList.get(i)).intValue();
                ++counter;
                continue;
            }
            tmp -= ((Integer)citNumList.get(i + 1)).intValue();
        }
        return (int)Math.sqrt(tmp);
    }

    public void updateTable() {
        this.fireTableStructureChanged();
    }

    protected boolean isSelfFiltered() {
        return this.so.isIsSelfcitationFiltered();
    }

    Content getContentAtRow(int rowNum) {
        Content content = new Content();
        content.setTitle(this.getValueAt(rowNum, 1).toString());
        String[] authors = this.getValueAt(rowNum, 2).toString().split(";");
        if (authors != null) {
            for (String author : authors) {
                content.addAuthor(author);
            }
        }
        content.setCitNum(this.getValueAt(rowNum, 3).toString().length());
        content.setSelfCitNum(Integer.parseInt(this.getValueAt(rowNum, 4).toString()));
        content.setPublisher(this.getValueAt(rowNum, 5).toString());
        content.setMedia(this.getValueAt(rowNum, 6).toString());
        content.setYear(Integer.parseInt(this.getValueAt(rowNum, 7).toString()));
        Content tmpContent = this.so.findByExample2(content);
        if (tmpContent != null) {
            content = tmpContent.clone();
        }
        return content;
    }

    public SearchObject getSo() {
        return this.so;
    }

    public void setSo(SearchObject so) {
        this.so = so;
    }

    class MyColumnListener {
        JTable table;

        public MyColumnListener(JTable table) {
            this.table = table;
        }
    }
}

