/*
 * Decompiled with CFR 0.152.
 */
package CM.GUI;

import CM.GUI.cmGUI;
import CM.Tools.FileWork;
import CM.core.PdfTools;
import CM.core.SearchObject;
import com.lowagie.text.DocumentException;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class ExportPanel
extends JPanel {
    private Logger log = Logger.getLogger(ExportPanel.class);
    boolean isSuccesFul = false;
    private ButtonGroup buttonGroupFileType;
    private JButton jButtonExp;
    private JButton jButton_browseEX;
    private JButton jButton_doNotOverwrite;
    private JButton jButton_overwrite;
    private JDialog jDialog_fileExists;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JTextField jTextField1;
    private SearchObject so = new SearchObject();
    static final JFileChooser fc = new JFileChooser();
    JInternalFrame frame;
    int[] sortIndexes;
    private boolean isPDFexport = false;
    private boolean isXLSexport = false;
    private String pdfFilePath = "untitled.pdf";
    private String xlsFilePath = "untitled.xls";
    private PdfTools expTools = new PdfTools();

    public ExportPanel(SearchObject so, JInternalFrame frame) {
        this.initComponents();
        this.so = so;
        this.frame = frame;
        this.buttonGroupFileType.add(this.jRadioButton1);
        this.buttonGroupFileType.add(this.jRadioButton2);
        this.buttonGroupFileType.add(this.jRadioButton3);
        this.jRadioButton1.setSelected(true);
    }

    ExportPanel(SearchObject so, JInternalFrame frame, int[] sortIndexes) {
        this.initComponents();
        this.so = so;
        this.frame = frame;
        this.buttonGroupFileType.add(this.jRadioButton1);
        this.buttonGroupFileType.add(this.jRadioButton2);
        this.buttonGroupFileType.add(this.jRadioButton3);
        this.jRadioButton1.setSelected(true);
        this.sortIndexes = sortIndexes;
    }

    private void initComponents() {
        this.buttonGroupFileType = new ButtonGroup();
        this.jDialog_fileExists = new JDialog();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton_overwrite = new JButton();
        this.jButton_doNotOverwrite = new JButton();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jButton_browseEX = new JButton();
        this.jButtonExp = new JButton();
        ResourceMap resourceMap = Application.getInstance(cmGUI.class).getContext().getResourceMap(ExportPanel.class);
        this.jDialog_fileExists.setTitle(resourceMap.getString("jDialog_fileExists.title", new Object[0]));
        this.jDialog_fileExists.setIconImage(null);
        this.jDialog_fileExists.setName("jDialog_fileExists");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        ApplicationActionMap actionMap = Application.getInstance(cmGUI.class).getContext().getActionMap(ExportPanel.class, this);
        this.jButton_overwrite.setAction(actionMap.get("overwrite"));
        this.jButton_overwrite.setText(resourceMap.getString("jButton_overwrite.text", new Object[0]));
        this.jButton_overwrite.setName("jButton_overwrite");
        this.jButton_overwrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportPanel.this.jButton_overwriteActionPerformed(evt);
            }
        });
        this.jButton_doNotOverwrite.setText(resourceMap.getString("jButton_doNotOverwrite.text", new Object[0]));
        this.jButton_doNotOverwrite.setName("jButton_doNotOverwrite");
        GroupLayout jDialog_fileExistsLayout = new GroupLayout(this.jDialog_fileExists.getContentPane());
        this.jDialog_fileExists.getContentPane().setLayout(jDialog_fileExistsLayout);
        jDialog_fileExistsLayout.setHorizontalGroup(jDialog_fileExistsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_fileExistsLayout.createSequentialGroup().addContainerGap().addGroup(jDialog_fileExistsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_fileExistsLayout.createSequentialGroup().addGroup(jDialog_fileExistsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(72, 72, 72)).addGroup(jDialog_fileExistsLayout.createSequentialGroup().addComponent(this.jButton_overwrite, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE).addComponent(this.jButton_doNotOverwrite, -2, 69, -2).addContainerGap()))));
        jDialog_fileExistsLayout.setVerticalGroup(jDialog_fileExistsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_fileExistsLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(29, 29, 29).addGroup(jDialog_fileExistsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_doNotOverwrite, -2, 23, -2).addComponent(this.jButton_overwrite)).addContainerGap()));
        this.jRadioButton1.setText(resourceMap.getString("jRadioButton1.text", new Object[0]));
        this.jRadioButton1.setName("jRadioButton1");
        this.jRadioButton2.setText(resourceMap.getString("jRadioButton2.text", new Object[0]));
        this.jRadioButton2.setName("jRadioButton2");
        this.jRadioButton3.setText(resourceMap.getString("jRadioButton3.text", new Object[0]));
        this.jRadioButton3.setName("jRadioButton3");
        this.jTextField1.setText(resourceMap.getString("jTextField1.text", new Object[0]));
        this.jTextField1.setName("jTextField1");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jButton_browseEX.setText(resourceMap.getString("jButton_browseEX.text", new Object[0]));
        this.jButton_browseEX.setName("jButton_browseEX");
        this.jButton_browseEX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportPanel.this.jButton_browseEXActionPerformed(evt);
            }
        });
        this.jButtonExp.setText(resourceMap.getString("jButtonExp.text", new Object[0]));
        this.jButtonExp.setName("jButtonExp");
        this.jButtonExp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExportPanel.this.jButtonExpMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton3).addComponent(this.jRadioButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonExp, -2, 110, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 230, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jTextField1, -2, 224, -2).addGap(18, 18, 18).addComponent(this.jButton_browseEX)))).addContainerGap(20, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, 20, -2).addComponent(this.jButton_browseEX)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton3)).addComponent(this.jButtonExp, -2, 51, -2)).addContainerGap(18, Short.MAX_VALUE)));
    }

    private void jButton_browseEXActionPerformed(ActionEvent evt) {
        fc.setApproveButtonText("Open");
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.jTextField1.setText(file.getAbsoluteFile().toString());
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    private void jButtonExpMouseClicked(MouseEvent evt) {
        String filePath;
        PdfTools pdf = new PdfTools();
        if (this.jRadioButton1.isSelected()) {
            try {
                filePath = this.jTextField1.getText().replaceAll("/", "//");
                if (!filePath.equals("") && !filePath.toLowerCase().endsWith(".pdf")) {
                    if (filePath.contains(".")) {
                        filePath = filePath.substring(0, filePath.indexOf(".") + 1);
                        filePath = filePath + "pdf";
                    } else {
                        filePath = filePath + ".pdf";
                    }
                }
                if (FileWork.fileOrDirectoryExists(filePath)) {
                    this.isPDFexport = true;
                    this.pdfFilePath = filePath;
                    this.showOverWriteDialog();
                } else {
                    this.isSuccesFul = pdf.exporPDF(filePath, this.so, this.sortIndexes);
                }
            }
            catch (FileNotFoundException ex) {
                this.isSuccesFul = false;
                JOptionPane.showMessageDialog(this, "Please specify the file-path!", "File-path error", 0);
                this.log.error((Object)ex);
            }
            catch (DocumentException ex) {
                this.isSuccesFul = false;
                this.log.error((Object)ex);
            }
        }
        if (this.jRadioButton2.isSelected()) {
            try {
                filePath = this.jTextField1.getText().replaceAll("/", "//");
                if (!filePath.equals("") && !filePath.toLowerCase().endsWith(".xls")) {
                    if (filePath.contains(".")) {
                        filePath = filePath.substring(0, filePath.indexOf(".") + 1);
                        filePath = filePath + "xls";
                    } else {
                        filePath = filePath + ".xls";
                    }
                }
                if (FileWork.fileOrDirectoryExists(filePath)) {
                    this.isXLSexport = true;
                    this.xlsFilePath = filePath;
                    this.showOverWriteDialog();
                } else {
                    this.isSuccesFul = pdf.exportXLS(filePath, this.so, this.sortIndexes);
                }
            }
            catch (FileNotFoundException ex) {
                this.isSuccesFul = false;
                JOptionPane.showMessageDialog(this, "Please specify the file-path!", "File-path error", 0);
                this.isSuccesFul = false;
                this.log.error((Object)ex);
            }
            catch (IOException ex) {
                this.isSuccesFul = false;
                this.log.error((Object)ex);
            }
        }
        if (this.jRadioButton3.isSelected()) {
            String filePath2;
            String filePathXLS = this.jTextField1.getText().replaceAll("/", "//");
            if (!filePathXLS.equals("") && !filePathXLS.toLowerCase().endsWith(".xls")) {
                if (filePathXLS.contains(".")) {
                    filePathXLS = filePathXLS.substring(0, filePathXLS.indexOf(".") + 1);
                    filePathXLS = filePathXLS + "xls";
                } else {
                    filePathXLS = filePathXLS + ".xls";
                }
            }
            if (!(filePath2 = this.jTextField1.getText().replaceAll("/", "//")).equals("") && !filePath2.toLowerCase().endsWith(".pdf")) {
                if (filePath2.contains(".")) {
                    filePath2 = filePath2.substring(0, filePath2.indexOf(".") + 1);
                    filePath2 = filePath2 + "pdf";
                } else {
                    filePath2 = filePath2 + ".pdf";
                }
            }
            if (FileWork.fileOrDirectoryExists(filePath2) || FileWork.fileOrDirectoryExists(filePathXLS)) {
                this.isPDFexport = true;
                this.isXLSexport = true;
                this.pdfFilePath = filePath2;
                this.xlsFilePath = filePathXLS;
                this.showOverWriteDialog();
            } else {
                try {
                    this.isSuccesFul = pdf.exporPDF(filePath2, this.so, this.sortIndexes);
                }
                catch (FileNotFoundException ex) {
                    this.isSuccesFul = false;
                    JOptionPane.showMessageDialog(this, "Please specify the file-path!", "File-path error", 0);
                    this.log.error((Object)ex);
                }
                catch (DocumentException ex) {
                    this.isSuccesFul = false;
                    this.log.error((Object)ex);
                }
                try {
                    this.isSuccesFul = pdf.exportXLS(filePathXLS, this.so, this.sortIndexes);
                }
                catch (FileNotFoundException ex) {
                    this.isSuccesFul = false;
                    JOptionPane.showMessageDialog(this, "Please specify the file-path!", "File-path error", 0);
                    this.log.error((Object)ex);
                }
                catch (IOException ex) {
                    this.isSuccesFul = false;
                    this.log.error((Object)ex);
                }
            }
        }
        if (this.isSuccesFul) {
            this.frame.dispose();
        }
    }

    private void jButton_overwriteActionPerformed(ActionEvent evt) {
        if (this.isPDFexport) {
            try {
                this.isSuccesFul = this.expTools.exporPDF(this.pdfFilePath, this.so, this.sortIndexes);
            }
            catch (FileNotFoundException ex) {
                this.log.error((Object)ex);
            }
            catch (DocumentException ex) {
                this.log.error((Object)ex);
            }
        }
        if (this.isXLSexport) {
            try {
                this.isSuccesFul = this.expTools.exportXLS(this.xlsFilePath, this.so, this.sortIndexes);
            }
            catch (FileNotFoundException ex) {
                this.log.error((Object)ex);
            }
            catch (IOException ex) {
                this.log.error((Object)ex);
            }
        }
        this.jDialog_fileExists.dispose();
        this.frame.dispose();
    }

    private void showOverWriteDialog() {
        this.jDialog_fileExists.setPreferredSize(new Dimension(250, 150));
        this.jDialog_fileExists.setMinimumSize(new Dimension(250, 150));
        this.jDialog_fileExists.setMaximumSize(new Dimension(250, 150));
        this.jDialog_fileExists.setResizable(false);
        this.jDialog_fileExists.setLocationRelativeTo(this);
        this.jDialog_fileExists.setVisible(true);
    }

    @Action
    public void cancel() {
        this.jDialog_fileExists.dispose();
        this.jButton_browseEXActionPerformed(new ActionEvent(this, 1, ""));
    }
}

