/*
 * Decompiled with CFR 0.152.
 */
package CM.GUI;

import CM.GUI.CvObject;
import CM.GUI.cmGUI;
import CM.GUI.cmGUIView;
import CM.Tools.Configuration;
import CM.core.FileWork;
import CM.core.XML_creator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class CreateCVPanel
extends JPanel {
    Logger log = Logger.getLogger(CreateCVPanel.class);
    static final JFileChooser fc = new JFileChooser();
    private final JInternalFrame frame;
    private cmGUIView mainPanel;
    private JLabel HomeCV;
    private JLabel NameCV;
    private JButton jButton_Back;
    private JButton jButton_Browse;
    private JButton jButton_CreateCV;
    private JTextField jTextField_HomeCV;
    private JTextField jTextField_NameCV;
    Configuration config = Configuration.getInstance();
    boolean isfirstClick = true;
    XML_creator xml = new XML_creator();

    public CreateCVPanel(JInternalFrame frame, cmGUIView mainPanel) {
        this.frame = frame;
        this.mainPanel = mainPanel;
        this.initComponents();
        this.jButton_Back.setVisible(false);
    }

    private void initComponents() {
        this.jTextField_NameCV = new JTextField();
        this.NameCV = new JLabel();
        this.HomeCV = new JLabel();
        this.jTextField_HomeCV = new JTextField();
        this.jButton_Browse = new JButton();
        this.jButton_CreateCV = new JButton();
        this.jButton_Back = new JButton();
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(cmGUI.class).getContext().getResourceMap(CreateCVPanel.class);
        this.jTextField_NameCV.setText(resourceMap.getString("jTextField_NameCV.text", new Object[0]));
        this.jTextField_NameCV.setName("jTextField_NameCV");
        this.NameCV.setText(resourceMap.getString("NameCV.text", new Object[0]));
        this.NameCV.setName("NameCV");
        this.HomeCV.setText(resourceMap.getString("HomeCV.text", new Object[0]));
        this.HomeCV.setName("HomeCV");
        this.jTextField_HomeCV.setText(resourceMap.getString("jTextField_HomeCV.text", new Object[0]));
        this.jTextField_HomeCV.setName("jTextField_HomeCV");
        this.jButton_Browse.setText(resourceMap.getString("jButton_Browse.text", new Object[0]));
        this.jButton_Browse.setName("jButton_Browse");
        this.jButton_Browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateCVPanel.this.jButton_BrowseActionPerformed(evt);
            }
        });
        ApplicationActionMap actionMap = Application.getInstance(cmGUI.class).getContext().getActionMap(CreateCVPanel.class, this);
        this.jButton_CreateCV.setAction(actionMap.get("createCV"));
        this.jButton_CreateCV.setText(resourceMap.getString("jButton_CreateCV.text", new Object[0]));
        this.jButton_CreateCV.setName("jButton_CreateCV");
        this.jButton_Back.setAction(actionMap.get("back"));
        this.jButton_Back.setText(resourceMap.getString("jButton_Back.text", new Object[0]));
        this.jButton_Back.setName("jButton_Back");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_NameCV, -2, 125, -2).addComponent(this.NameCV).addComponent(this.HomeCV).addGroup(layout.createSequentialGroup().addComponent(this.jTextField_HomeCV, -2, 227, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_Browse))).addContainerGap(31, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(215, Short.MAX_VALUE).addComponent(this.jButton_Back).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_CreateCV).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.NameCV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_NameCV, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.HomeCV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField_HomeCV, -2, -1, -2).addComponent(this.jButton_Browse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_CreateCV).addComponent(this.jButton_Back)).addContainerGap()));
    }

    private void jButton_BrowseActionPerformed(ActionEvent evt) {
        fc.setFileSelectionMode(1);
        fc.setApproveButtonText("Open");
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.jTextField_HomeCV.setText(file.getAbsoluteFile().toString());
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    @Action
    public void createCV() {
        String filePath = this.composePath();
        this.jButton_Back.setVisible(true);
        this.jButton_CreateCV.setText("Finish");
        this.jButton_Browse.setVisible(false);
        this.jTextField_HomeCV.setVisible(false);
        this.jTextField_NameCV.setVisible(false);
        this.NameCV.setText("Your CV will be located here:");
        this.HomeCV.setText(filePath);
        if (FileWork.fileOrDirectoryExists(filePath) && !this.isfirstClick) {
            JOptionPane.showMessageDialog(this, "Directory already exits!", "Error", 0);
        } else if (!this.isfirstClick) {
            CvObject cv = new CvObject(this.jTextField_NameCV.getText(), new Date());
            String data = this.xml.createCVdescriptor(cv);
            if (FileWork.createDir(filePath)) {
                try {
                    filePath = filePath + this.config.getCvDescriptorName();
                    FileWork.write(data, filePath, false);
                }
                catch (IOException ex) {
                    this.log.error((Object)ex);
                }
                cmGUIView.setSearchFrameVisible(true);
                cmGUIView.setWelcomeFrameVisible((boolean)false);
                this.frame.dispose();
                this.mainPanel.setCVSummaryVisible(filePath);
            } else {
                JOptionPane.showMessageDialog(this, "Sorry, but it is not possible to create the directory!", "Error", 0);
            }
        }
        this.isfirstClick = false;
    }

    private String composePath() {
        String path = "";
        if (this.jTextField_NameCV.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please specify a name for your CV!", "Error", 0);
        } else if (this.jTextField_HomeCV.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please specify a path for your CV!", "Error", 0);
        } else {
            path = this.jTextField_HomeCV.getText() + "\\" + this.jTextField_NameCV.getText() + "\\";
        }
        return path;
    }

    @Action
    public void back() {
        this.isfirstClick = true;
        this.jButton_Back.setVisible(false);
        this.jButton_CreateCV.setText("Next");
        this.jButton_Browse.setVisible(true);
        this.jTextField_HomeCV.setVisible(true);
        this.jTextField_NameCV.setVisible(true);
        this.NameCV.setText("Name of your CV:");
        this.HomeCV.setText("Your CV's home:");
    }
}

