/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class UnaryMinusEval
implements Function {
    public static final Function instance = new UnaryMinusEval();

    private UnaryMinusEval() {
    }

    public ValueEval evaluate(ValueEval[] args, int srcRow, short srcCol) {
        double d;
        if (args.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue(args[0], srcRow, srcCol);
            d = OperandResolver.coerceValueToDouble(ve);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        if (d == 0.0) {
            return NumberEval.ZERO;
        }
        return new NumberEval(-d);
    }
}

