/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.transaction;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.TransactionException;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.sessions.ExternalTransactionController;
import oracle.toplink.essentials.transaction.AbstractSynchronizationListener;
import oracle.toplink.essentials.transaction.SynchronizationListenerFactory;

public abstract class AbstractTransactionController
implements ExternalTransactionController {
    protected Hashtable unitsOfWork = new Hashtable();
    protected AbstractSession session;
    protected SynchronizationListenerFactory listenerFactory;
    protected ThreadLocal activeUnitOfWorkThreadLocal = new ThreadLocal();

    public void bindToCurrentTransaction(UnitOfWorkImpl unitOfWork, AbstractSession session) {
        Object status = this.getTransactionStatus();
        this.logTxStateTrace(unitOfWork, "TX_bind", status);
        try {
            Object txn = this.getTransaction();
            if (txn == null) {
                unitOfWork.beginTransaction();
                txn = this.getTransaction();
            }
            if (txn == null) {
                throw TransactionException.externalTransactionNotActive();
            }
            AbstractSynchronizationListener listener = this.getListenerFactory().newSynchronizationListener(unitOfWork, session, txn, this);
            this.registerSynchronization_impl(listener, txn);
            unitOfWork.setSynchronized(true);
        }
        catch (Exception exception) {
            throw TransactionException.errorBindingToExternalTransaction(exception);
        }
    }

    public void beginTransaction(AbstractSession session) {
        try {
            Object status = this.getTransactionStatus();
            this.logTxStateTrace(session, "TX_begin", status);
            if (this.canBeginTransaction_impl(status)) {
                this.logTxTrace(session, "TX_beginningTxn", null);
                this.beginTransaction_impl();
                session.setWasJTSTransactionInternallyStarted(true);
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorBeginningExternalTransaction(exception);
        }
    }

    public void commitTransaction(AbstractSession session) {
        try {
            Object status = this.getTransactionStatus();
            this.logTxStateTrace(session, "TX_commit", status);
            if (this.canCommitTransaction_impl(status)) {
                this.logTxTrace(session, "TX_committingTxn", null);
                session.setWasJTSTransactionInternallyStarted(false);
                this.commitTransaction_impl();
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorCommittingExternalTransaction(exception);
        }
    }

    public void rollbackTransaction(AbstractSession session) {
        try {
            Object status = this.getTransactionStatus();
            this.logTxStateTrace(session, "TX_rollback", status);
            session.setWasJTSTransactionInternallyStarted(false);
            if (this.canRollbackTransaction_impl(status) && this.getTransaction() != null) {
                this.logTxTrace(session, "TX_rollingBackTxn", null);
                this.rollbackTransaction_impl();
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorRollingBackExternalTransaction(exception);
        }
    }

    public void markTransactionForRollback() {
        try {
            this.markTransactionForRollback_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorMarkingTransactionForRollback(exception);
        }
    }

    public Object getTransaction() {
        try {
            return this.getTransaction_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransaction(exception);
        }
    }

    public Object getTransactionKey(Object transaction) {
        try {
            return this.getTransactionKey_impl(transaction);
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransaction(exception);
        }
    }

    public Object getTransactionStatus() {
        try {
            return this.getTransactionStatus_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransactionStatus(exception);
        }
    }

    public boolean noTransactionOrRolledBackOrCommited() {
        try {
            Object status = this.getTransactionStatus();
            return this.canBeginTransaction_impl(status) || this.canMergeUnitOfWork_impl(status) || this.isRolledBack_impl(status);
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransactionStatus(exception);
        }
    }

    public abstract boolean isRolledBack_impl(Object var1);

    public boolean hasActiveUnitOfWork() {
        return this.lookupActiveUnitOfWork() != null;
    }

    public UnitOfWorkImpl getActiveUnitOfWork() {
        Object transaction = this.getTransaction();
        if (transaction == null) {
            return null;
        }
        UnitOfWorkImpl activeUnitOfWork = this.lookupActiveUnitOfWork(transaction);
        if (activeUnitOfWork == null) {
            activeUnitOfWork = (UnitOfWorkImpl)this.getSession().acquireUnitOfWork();
            Object transactionKey = this.getTransactionKey(transaction);
            this.addUnitOfWork(transactionKey, activeUnitOfWork);
            activeUnitOfWork.setTransaction(transaction);
            this.activeUnitOfWorkThreadLocal.set(activeUnitOfWork);
        }
        return activeUnitOfWork;
    }

    public UnitOfWorkImpl lookupActiveUnitOfWork() {
        return this.lookupActiveUnitOfWork(this.getTransaction());
    }

    public UnitOfWorkImpl lookupActiveUnitOfWork(Object transaction) {
        if (transaction == null) {
            return null;
        }
        Object transactionKey = this.getTransactionKey(transaction);
        UnitOfWorkImpl activeUnitOfWork = (UnitOfWorkImpl)this.activeUnitOfWorkThreadLocal.get();
        if (activeUnitOfWork != null && transaction == activeUnitOfWork.getTransaction()) {
            return activeUnitOfWork;
        }
        activeUnitOfWork = (UnitOfWorkImpl)this.getUnitsOfWork().get(transactionKey);
        if (activeUnitOfWork != null) {
            activeUnitOfWork.setTransaction(transaction);
        }
        this.activeUnitOfWorkThreadLocal.set(activeUnitOfWork);
        return activeUnitOfWork;
    }

    public void addUnitOfWork(Object transaction, UnitOfWorkImpl activeUnitOfWork) {
        this.activeUnitOfWorkThreadLocal.set(null);
        this.getUnitsOfWork().put(transaction, activeUnitOfWork);
    }

    public void removeUnitOfWork(Object transaction) {
        if (transaction != null) {
            this.getUnitsOfWork().remove(transaction);
        }
        this.activeUnitOfWorkThreadLocal.set(null);
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public Hashtable getUnitsOfWork() {
        return this.unitsOfWork;
    }

    protected void setUnitsOfWork(Hashtable unitsOfWork) {
        this.unitsOfWork = unitsOfWork;
    }

    public SynchronizationListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(SynchronizationListenerFactory factory) {
        this.listenerFactory = factory;
    }

    public void registerSynchronizationListener(UnitOfWorkImpl uow, AbstractSession session) throws DatabaseException {
        this.bindToCurrentTransaction(uow, session);
    }

    public Object jndiLookup(String jndiName) {
        InitialContext context = null;
        Object jndiObject = null;
        try {
            context = new InitialContext();
            jndiObject = context.lookup(jndiName);
        }
        catch (NamingException ex) {
            throw TransactionException.jndiLookupException(jndiName, ex);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception ex2) {}
        }
        return jndiObject;
    }

    public void logTxTrace(AbstractSession session, String msgInd, Object[] args) {
        session.log(2, "transaction", msgInd, args);
    }

    public void logTxStateTrace(AbstractSession session, String msgInd, Object status) {
        if (session.shouldLog(2, "transaction")) {
            String statusString = this.statusToString_impl(status);
            Object[] args = new Object[]{statusString};
            session.log(2, "transaction", msgInd, args);
        }
    }

    protected abstract void registerSynchronization_impl(AbstractSynchronizationListener var1, Object var2) throws Exception;

    protected abstract Object getTransaction_impl() throws Exception;

    protected abstract Object getTransactionKey_impl(Object var1) throws Exception;

    protected abstract Object getTransactionStatus_impl() throws Exception;

    protected abstract void beginTransaction_impl() throws Exception;

    protected abstract void commitTransaction_impl() throws Exception;

    protected abstract void rollbackTransaction_impl() throws Exception;

    protected abstract void markTransactionForRollback_impl() throws Exception;

    protected abstract boolean canBeginTransaction_impl(Object var1);

    protected abstract boolean canCommitTransaction_impl(Object var1);

    protected abstract boolean canRollbackTransaction_impl(Object var1);

    protected abstract boolean canIssueSQLToDatabase_impl(Object var1);

    protected abstract boolean canMergeUnitOfWork_impl(Object var1);

    protected abstract String statusToString_impl(Object var1);
}

