/*
 * Decompiled with CFR 0.152.
 */
package CM.GUI;

import CM.GUI.SoAndFileName;
import java.util.ArrayList;
import java.util.Date;

public class CvObject {
    private String name;
    private Date createdAt;
    int selfCitNumALL;
    ArrayList<SoAndFileName> snapshots = new ArrayList();

    public CvObject(String name, Date createdAt) {
        this.name = name;
        this.createdAt = createdAt;
    }

    public CvObject() {
    }

    public SoAndFileName getSoByFileName(String name) {
        for (SoAndFileName soAndFileName : this.snapshots) {
            if (!soAndFileName.getFileName().equals(name)) continue;
            return soAndFileName;
        }
        return null;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getName() {
        return this.name;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<SoAndFileName> getSnapshots() {
        return this.snapshots;
    }

    public void setSnapshots(ArrayList<SoAndFileName> snapshots) {
        this.snapshots = snapshots;
    }

    public void addSnapshot(SoAndFileName snapshot) {
        this.snapshots.add(snapshot);
    }

    public void removeSnapshot(String snapshot) {
        this.snapshots.remove(snapshot);
    }

    public ArrayList<String> getAllAreas() {
        ArrayList<String> allAreas = new ArrayList<String>();
        for (SoAndFileName soaf : this.snapshots) {
            for (String area : soaf.getSo().getAreas()) {
                if (allAreas.contains(area)) continue;
                allAreas.add(area);
            }
        }
        return allAreas;
    }

    public ArrayList<String> getAllNamesExcl() {
        ArrayList<String> allNamesExcl = new ArrayList<String>();
        for (SoAndFileName soaf : this.snapshots) {
            for (String excl : soaf.getSo().getAreas()) {
                if (allNamesExcl.contains(excl)) continue;
                allNamesExcl.add(excl);
            }
        }
        return allNamesExcl;
    }

    public ArrayList<String> getAllNamesInc() {
        ArrayList<String> allNamesInc = new ArrayList<String>();
        for (SoAndFileName soaf : this.snapshots) {
            for (String incl : soaf.getSo().getAreas()) {
                if (allNamesInc.contains(incl)) continue;
                allNamesInc.add(incl);
            }
        }
        return allNamesInc;
    }

    public int getCitNumALL() {
        return 0;
    }

    public int getFromALL() {
        int fromALL = 30000;
        for (SoAndFileName soaf : this.snapshots) {
            if (soaf.getSo().getYearFrom() == 0) {
                fromALL = 0;
                break;
            }
            if (soaf.getSo().getYearFrom() >= fromALL) continue;
            fromALL = soaf.getSo().getYearFrom();
        }
        return fromALL;
    }

    public int getSelfCitNumALL() {
        return this.selfCitNumALL;
    }

    public int getToALL() {
        int toALL = -2000;
        for (SoAndFileName soaf : this.snapshots) {
            if (soaf.getSo().getYearTo() == 0) {
                toALL = 0;
                break;
            }
            if (soaf.getSo().getYearTo() <= toALL) continue;
            toALL = soaf.getSo().getYearTo();
        }
        return toALL;
    }
}

